/*==================================================================================
===                         SA Turf Wars Ultimate v1                             ===
===                                 By Popo                                      ===
===                                                                              ===
===              Inspired by and bason on LS Turf Wars by [W]Hustler             ===
===                                                                              ===
===  Credits: [W]Hustler, Simon, Mike, Jax, Sintax, -Seif-, Lethal, [NB]90NINE   ===
===           HAMM3R and LeD.                                                    ===
==================================================================================*/

#include <a_samp>
#include <core>
#include <float>

#define dcmd(%1,%2,%3) if ((strcmp((%3)[1], #%1, true, (%2)) == 0) && ((((%3)[(%2) + 1] == 0) && (dcmd_%1(playerid, "")))||(((%3)[(%2) + 1] == 32) && (dcmd_%1(playerid, (%3)[(%2) + 2]))))) return 1

#define SLOTS            100     // how many slots the server got.
#define ATTACK_TIME      180000  // Three minutes. (60000 = 1 minute)
#define STANDINTURF_TIME 20000   // Twenty secs. (Always some extra secs are added because of the CheckPlayers timer)
#define ATTACK_KILLS     5       // Kills to start a turfwar.
#define MEMBERS_NEEDED   10      // Members in turf to start turfwar.
#define TEAMSCORE        500     // Teamscore to take over all the opponends turf.
#define DROP_WEAPONS     1
#define DROP_LENGTH      10000   // 10 Seconds.
#define MAX_TEAMS        15
#define MAX_TURFS        99

//================================== COLORS ====================================
#define COLOR_GREY     0xAFAFAFAA
#define COLOR_WHITE    0xFFFFFFAA
#define COLOR_YELLOW   0xFFFF00AA
#define COLOR_GREEN    0x00B000FF
#define COLOR_ORANGE   0xFF9900AA
#define COLOR_RED      0xFF4646FF
#define COLOR_WHITE    0xFFFFFFAA
#define COLOR_ME       0xFF99FFFF
#define COLOR_INACTIVE 0xC8BEBEFF
#define COLOR_FLASH    0xFF000080
#define COLOR_FLASH2   0xFFFFFF80
#define COLOR_ACHAT    0x8080FFFF
#define COLOR_TPM      0x53A6A6FF

//Team Colors
#define AZTECA_COLOR   0x33FFFF80
#define VAGOS_COLOR    0xF5BE1880
#define BALLA_COLOR    0x9245AB80
#define GROVE_COLOR    0x007D0080
#define HOODLUM_COLOR  0x6D363680
#define RIFA_COLOR     0x99FFFF80
#define TRIAD_COLOR    0xFF009980
#define NANG_COLOR     0x99000080
#define WORKER_COLOR   0x1D584A80
#define COP_COLOR      0x0080FF80
#define GUARD_COLOR    0x44444480
#define BIKER_COLOR    0xFF464680
#define MAFIA_COLOR    0x8888FF80
#define FANCLUB_COLOR  0xFFFF6680
#define MECHANIC_COLOR 0x99FF0080

//==============================================================================
static gTeam[ SLOTS ];
new bounty[ SLOTS ];
new playerCheckpoint[ SLOTS ];
new ShowPM[ SLOTS ];
new ShowTPM[ SLOTS ];
new Spawned[ SLOTS ];
new TeamKills[ SLOTS ];
new Float:X250[ SLOTS ], Float:Y250[ SLOTS ], Float:Z250[ SLOTS ];
new PlayerOnDuty[ SLOTS ];
new lTMoney[ SLOTS ];
new lSMoney[ SLOTS ];
new TimerStarted[ MAX_TURFS ];
new savePos;
new worldTime;
new Menu:LSAMenu;
new Menu:LVAMenu;
new Menu:SFAMenu;
new Menu:LSTMenu;
new Menu:LVTMenu;
new Menu:SFTMenu;
new randcar[ 14 ] = { 541, 411, 480, 451, 579, 589, 496, 400, 560, 559, 561, 429, 562, 415 };

new gDropPickup[101] = -1;
new gDenyWeaponDrop[] = {1,8,11,12,13,17,19,20,35,36,37,38,39,40,41,43,44,45};
#pragma unused gDenyWeaponDrop

//=================================== TEAM STUFF ===============================
enum
{
    TEAM_AZTECA,
    TEAM_VAGOS,
    TEAM_BALLA,
    TEAM_GROVE,
    TEAM_HOODLUM,
    TEAM_RIFA,
    TEAM_TRIAD,
    TEAM_NANG,
    TEAM_WORKER,
    TEAM_COP,
    TEAM_GUARD,
    TEAM_BIKER,
    TEAM_MAFIA,
    TEAM_FANCLUB,
    TEAM_MECHANIC
};

enum teaminfo
{
 	 TeamName[ 32 ],
	 TeamColor,
	 TurfWarsWon,
	 TurfWarsLost,
	 RivalsKilled,
	 HomiesDied,
	 TeamScore
}

new TeamInfo[ MAX_TEAMS ][ teaminfo ]= {
// LS teams
{ "Aztecas",   AZTECA_COLOR,   0, 0, 0, 0, 0},
{ "Vagos",     VAGOS_COLOR,    0, 0, 0, 0, 0},
{ "Ballas",    BALLA_COLOR,    0, 0, 0, 0, 0},
{ "O.G.F.",    GROVE_COLOR,    0, 0, 0, 0, 0},
{ "Hoodlums",  HOODLUM_COLOR,  0, 0, 0, 0, 0},
// SF teams
{ "Rifas",     RIFA_COLOR,     0, 0, 0, 0, 0},
{ "Triads",    TRIAD_COLOR,    0, 0, 0, 0, 0},
{ "Da Nang",   NANG_COLOR,     0, 0, 0, 0, 0},
{ "Workers",   WORKER_COLOR,   0, 0, 0, 0, 0},
{ "Cops",      COP_COLOR,      0, 0, 0, 0, 0},
// LV teams
{ "Guards",    GUARD_COLOR,    0, 0, 0, 0, 0},
{ "Bikers",    BIKER_COLOR,    0, 0, 0, 0, 0},
{ "Mafia",     MAFIA_COLOR,    0, 0, 0, 0, 0},
{ "E.F.C.",    FANCLUB_COLOR,  0, 0, 0, 0, 0},
{ "Mechanics", MECHANIC_COLOR, 0, 0, 0, 0, 0}
};

//=================================== TURF STUFF ===============================
enum tinfo
{
	 turfID,
 	 turfName[ 40 ],
 	 cityName[ 40 ],
	 Float:zMinX,
	 Float:zMinY,
	 Float:zMaxX,
	 Float:zMaxY,
	 TurfColor,
	 TurfOwner,
	 TurfAttacker,
	 TurfKills,
	 TurfAttackKills,
	 TurfWarStarted,
	 MIT // Members In Turf
}

new turfs[ MAX_TURFS ][ tinfo ] = {
// LS turfs
{  0, "Ganton",            "LS", 2222.50, -1852.80, 2632.80, -1722.30, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{  1, "Ganton",            "LS", 2222.50, -1722.30, 2632.80, -1628.50, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{  2, "Idlewood",          "LS", 1812.60, -1852.80, 1971.60, -1742.30, AZTECA_COLOR,  TEAM_AZTECA,  -1, 0, 0, 0, 0},
{  3, "Idlewood",          "LS", 1951.60, -1742.30, 2124.60, -1602.30, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{  4, "Idlewood",          "LS", 1812.60, -1602.30, 2124.60, -1449.60, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{  5, "Idlewood",          "LS", 2124.60, -1742.30, 2222.50, -1494.00, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{  6, "Idlewood",          "LS", 1971.60, -1852.80, 2222.50, -1742.30, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{  7, "Idlewood",          "LS", 1812.60, -1742.30, 1951.60, -1602.30, AZTECA_COLOR,  TEAM_AZTECA,  -1, 0, 0, 0, 0},
{  8, "Willow Field",      "LS", 1970.60, -2179.20, 2089.00, -1852.80, AZTECA_COLOR,  TEAM_AZTECA,  -1, 0, 0, 0, 0},
{  9, "Willow Field",      "LS", 2089.00, -1989.90, 2324.00, -1852.80, AZTECA_COLOR,  TEAM_AZTECA,  -1, 0, 0, 0, 0},
{ 10, "Willow Field",      "LS", 2089.00, -2235.80, 2201.80, -1989.90, AZTECA_COLOR,  TEAM_AZTECA,  -1, 0, 0, 0, 0},
{ 11, "Willow Field",      "LS", 2324.00, -2059.20, 2541.70, -1852.80, HOODLUM_COLOR, TEAM_HOODLUM, -1, 0, 0, 0, 0},
{ 12, "Jefferson",         "LS", 2056.80, -1372.00, 2281.40, -1210.70, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 13, "Jefferson",         "LS", 2056.80, -1210.70, 2185.30, -1126.30, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 14, "Jefferson",         "LS", 2056.80, -1449.60, 2266.20, -1372.00, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 15, "East Los Santos",   "LS", 2421.00, -1628.50, 2632.80, -1454.30, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{ 16, "East Los Santos",   "LS", 2222.50, -1628.50, 2421.00, -1494.00, GROVE_COLOR,   TEAM_GROVE,   -1, 0, 0, 0, 0},
{ 17, "East Los Santos",   "LS", 2266.20, -1494.00, 2381.60, -1372.00, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 18, "East Los Santos",   "LS", 2281.60, -1372.00, 2381.60, -1135.00, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 19, "East Los Santos",   "LS", 2381.60, -1454.30, 2462.10, -1135.00, VAGOS_COLOR,   TEAM_VAGOS,   -1, 0, 0, 0, 0},
{ 20, "East Los Santos",   "LS", 2462.10, -1454.30, 2581.70, -1135.00, VAGOS_COLOR,   TEAM_VAGOS,   -1, 0, 0, 0, 0},
{ 21, "East Beach",        "LS", 2632.80, -1852.80, 2959.30, -1668.10, HOODLUM_COLOR, TEAM_HOODLUM, -1, 0, 0, 0, 0},
{ 22, "East Beach",        "LS", 2632.80, -1668.10, 2747.70, -1393.40, HOODLUM_COLOR, TEAM_HOODLUM, -1, 0, 0, 0, 0},
{ 23, "East Beach",        "LS", 2747.70, -1668.10, 2959.30, -1498.60, HOODLUM_COLOR, TEAM_HOODLUM, -1, 0, 0, 0, 0},
{ 24, "East Beach",        "LS", 2747.70, -1498.60, 2959.30, -1120.00, HOODLUM_COLOR, TEAM_HOODLUM, -1, 0, 0, 0, 0},
{ 25, "Playa Del Seville", "LS", 2703.50, -2126.90, 2959.30, -1852.80, HOODLUM_COLOR, TEAM_HOODLUM, -1, 0, 0, 0, 0},
{ 26, "El Corona",         "LS", 1812.60, -2179.20, 1970.60, -1852.80, AZTECA_COLOR,  TEAM_AZTECA,  -1, 0, 0, 0, 0},
{ 27, "El Corona",         "LS", 1692.60, -2179.20, 1812.60, -1842.20, AZTECA_COLOR,  TEAM_AZTECA,  -1, 0, 0, 0, 0},
{ 28, "Glen Park",         "LS", 1812.60, -1350.70, 2056.80, -1100.80, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 29, "Los Flores",        "LS", 2581.70, -1393.40, 2747.70, -1135.00, VAGOS_COLOR,   TEAM_VAGOS,   -1, 0, 0, 0, 0},
{ 30, "Las Colinas",       "LS", 1994.30, -1100.80, 2056.80,  -920.80, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 31, "Las Colinas",       "LS", 2056.80, -1126.30, 2126.80,  -920.80, BALLA_COLOR,   TEAM_BALLA,   -1, 0, 0, 0, 0},
{ 32, "Las Colinas",       "LS", 2185.30, -1154.50, 2281.40,  -934.40, VAGOS_COLOR,   TEAM_VAGOS,   -1, 0, 0, 0, 0},
{ 33, "Las Colinas",       "LS", 2126.80, -1126.30, 2185.30,  -934.40, VAGOS_COLOR,   TEAM_VAGOS,   -1, 0, 0, 0, 0},
{ 34, "Las Colinas",       "LS", 2632.70, -1135.00, 2747.70,  -945.00, VAGOS_COLOR,   TEAM_VAGOS,   -1, 0, 0, 0, 0},
{ 35, "Las Colinas",       "LS", 2281.40, -1135.00, 2632.70,  -945.00, VAGOS_COLOR,   TEAM_VAGOS,   -1, 0, 0, 0, 0},
// LV turfs
{ 36, "Four Dragons Casino",    "LV", 1817.30,  863.20, 2027.30, 1083.20, FANCLUB_COLOR,  TEAM_FANCLUB,  -1, 0, 0, 0, 0},
{ 37, "Pink Swan",              "LV", 1817.30, 1083.20, 2027.30, 1283.20, FANCLUB_COLOR,  TEAM_FANCLUB,  -1, 0, 0, 0, 0},
{ 38, "High Roller",            "LV", 1817.30, 1283.20, 2027.30, 1469.20, FANCLUB_COLOR,  TEAM_FANCLUB,  -1, 0, 0, 0, 0},
{ 39, "Come-A-Lot",             "LV", 2087.30,  943.20, 2623.10, 1203.20, FANCLUB_COLOR,  TEAM_FANCLUB,  -1, 0, 0, 0, 0},
{ 40, "Caligula's Place",       "LV", 2087.30, 1543.20, 2437.30, 1703.20, MAFIA_COLOR,    TEAM_MAFIA,    -1, 0, 0, 0, 0},
{ 41, "Caligula's Place",       "LV", 2137.40, 1703.20, 2437.30, 1783.20, MAFIA_COLOR,    TEAM_MAFIA,    -1, 0, 0, 0, 0},
{ 42, "Royal Casino",           "LV", 2087.30, 1383.20, 2437.30, 1543.20, MAFIA_COLOR,    TEAM_MAFIA,    -1, 0, 0, 0, 0},
{ 43, "Strip",                  "LV", 2027.40,  863.20, 2087.30, 1703.20, MAFIA_COLOR,    TEAM_MAFIA,    -1, 0, 0, 0, 0},
{ 44, "Strip",                  "LV", 2027.40, 1703.20, 2137.40, 1783.20, MAFIA_COLOR,    TEAM_MAFIA,    -1, 0, 0, 0, 0},
{ 45, "Pilgrim",                "LV", 2437.30, 1383.20, 2624.40, 1783.20, MAFIA_COLOR,    TEAM_MAFIA,    -1, 0, 0, 0, 0},
{ 46, "Pirates in men's pants", "LV", 1817.30, 1469.20, 2027.40, 1703.20, MAFIA_COLOR,    TEAM_FANCLUB,  -1, 0, 0, 0, 0},
{ 47, "Camel's Toe",            "LV", 2087.30, 1203.20, 2640.40, 1383.20, FANCLUB_COLOR,  TEAM_FANCLUB,  -1, 0, 0, 0, 0},
{ 48, "LV Airport",             "LV", 1236.60, 1203.20, 1457.30, 1883.10, GUARD_COLOR,    TEAM_GUARD,    -1, 0, 0, 0, 0},
{ 49, "LV Airport",             "LV", 1457.30, 1203.20, 1777.30, 1883.10, GUARD_COLOR,    TEAM_GUARD,    -1, 0, 0, 0, 0},
{ 50, "LV Airport",             "LV", 1457.30, 1143.20, 1777.40, 1203.20, GUARD_COLOR,    TEAM_GUARD,    -1, 0, 0, 0, 0},
{ 51, "Redsands West",          "LV", 1236.60, 1883.10, 1777.30, 2142.80, MECHANIC_COLOR, TEAM_MECHANIC, -1, 0, 0, 0, 0},
{ 52, "Redsands West",          "LV", 1297.40, 2142.80, 1777.30, 2243.20, MECHANIC_COLOR, TEAM_MECHANIC, -1, 0, 0, 0, 0},
{ 53, "Redsands West",          "LV", 1377.30, 2243.20, 1704.50, 2433.20, MECHANIC_COLOR, TEAM_MECHANIC, -1, 0, 0, 0, 0},
{ 54, "Redsands West",          "LV", 1704.50, 2243.20, 1777.30, 2342.80, MECHANIC_COLOR, TEAM_MECHANIC, -1, 0, 0, 0, 0},
{ 55, "Old Venturas Strip",     "LV", 2162.30, 2012.10, 2685.10, 2202.70, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
{ 56, "Starfish Casino",        "LV", 2437.30, 1783.20, 2685.10, 2012.10, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
{ 57, "Starfish Casino",        "LV", 2162.30, 1883.20, 2437.30, 2012.10, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
{ 58, "Clown's Pocket",         "LV", 2162.30, 1783.20, 2437.30, 1883.20, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
{ 59, "LVA Freight Depot",      "LV", 1457.30,  863.20, 1777.40, 1143.20, GUARD_COLOR,    TEAM_GUARD,    -1, 0, 0, 0, 0},
{ 60, "Strip",                  "LV", 2027.40, 1783.20, 2162.30, 1863.20, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
{ 61, "Visage",                 "LV", 1817.30, 1863.20, 2106.70, 2011.80, GUARD_COLOR,    TEAM_GUARD,    -1, 0, 0, 0, 0},
{ 62, "Visage",                 "LV", 1817.30, 1703.20, 2027.40, 1863.20, GUARD_COLOR,    TEAM_GUARD,    -1, 0, 0, 0, 0},
{ 63, "Redsands East",          "LV", 1817.30, 2011.80, 2106.70, 2202.70, MECHANIC_COLOR, TEAM_MECHANIC, -1, 0, 0, 0, 0},
{ 64, "Redsands East",          "LV", 1817.30, 2202.70, 2011.90, 2342.80, MECHANIC_COLOR, TEAM_MECHANIC, -1, 0, 0, 0, 0},
{ 65, "Redsands East",          "LV", 1848.40, 2342.80, 2011.90, 2478.40, MECHANIC_COLOR, TEAM_MECHANIC, -1, 0, 0, 0, 0},
{ 66, "Roca Escalante",         "LV", 2237.40, 2202.70, 2536.40, 2542.50, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
{ 67, "Roca Escalante",         "LV", 2536.40, 2202.70, 2625.10, 2442.50, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
{ 68, "Strip",                  "LV", 2106.70, 1863.20, 2162.30, 2202.70, BIKER_COLOR,    TEAM_BIKER,    -1, 0, 0, 0, 0},
// SF turfs
{ 69, "Hashbury",          "SF", -2511.0, -215.0, -2242.0,  -61.0, RIFA_COLOR,   TEAM_RIFA,   -1, 0, 0, 0, 0},
{ 70, "Garcia",            "SF", -2509.0,  -61.0, -2242.0,   89.0, RIFA_COLOR,   TEAM_RIFA,   -1, 0, 0, 0, 0},
{ 71, "Garcia",            "SF", -2509.0,   89.0, -2241.0,  263.0, RIFA_COLOR,   TEAM_RIFA,   -1, 0, 0, 0, 0},
{ 72, "King's",            "SF", -2511.0,  263.0, -2241.0,  429.0, RIFA_COLOR,   TEAM_RIFA,   -1, 0, 0, 0, 0},
{ 73, "Queens",            "SF", -2511.0,  429.0, -2241.0,  578.0, TRIAD_COLOR,  TEAM_TRIAD,  -1, 0, 0, 0, 0},
{ 74, "Juniper Hill",      "SF", -2510.0,  578.0, -2241.0,  819.0, TRIAD_COLOR,  TEAM_TRIAD,  -1, 0, 0, 0, 0},
{ 75, "Chna Town",         "SF", -2241.0,  558.0, -2078.0,  818.0, TRIAD_COLOR,  TEAM_TRIAD,  -1, 0, 0, 0, 0},
{ 76, "King's",            "SF", -2241.0,  319.0, -2078.0,  558.0, TRIAD_COLOR,  TEAM_TRIAD,  -1, 0, 0, 0, 0},
{ 77, "Doherty",           "SF", -2242.0, -227.0, -1975.0,  -61.0, RIFA_COLOR,   TEAM_RIFA,   -1, 0, 0, 0, 0},
{ 78, "Doherty",           "SF", -2242.0,  -61.0, -1976.0,  136.0, WORKER_COLOR, TEAM_WORKER, -1, 0, 0, 0, 0},
{ 79, "Doherty",           "SF", -2242.0,  136.0, -1976.0,  320.0, WORKER_COLOR, TEAM_WORKER, -1, 0, 0, 0, 0},
{ 80, "Downtown",          "SF", -2079.0,  320.0, -1808.0,  471.0, WORKER_COLOR, TEAM_WORKER, -1, 0, 0, 0, 0},
{ 81, "Doherty",           "SF", -1974.0, -231.0, -1807.0,   27.0, WORKER_COLOR, TEAM_WORKER, -1, 0, 0, 0, 0},
{ 82, "Cranberry Station", "SF", -1974.0,   27.0, -1807.0,  320.0, WORKER_COLOR, TEAM_WORKER, -1, 0, 0, 0, 0},
{ 83, "Downtown",          "SF", -2078.0,  633.0, -1868.0,  818.0, TRIAD_COLOR,  TEAM_TRIAD,  -1, 0, 0, 0, 0},
{ 84, "Downtown",          "SF", -2078.0,  470.0, -1868.0,  633.0, TRIAD_COLOR,  TEAM_TRIAD,  -1, 0, 0, 0, 0},
{ 85, "Downtown",          "SF", -1869.0,  472.0, -1659.0,  613.0, COP_COLOR,    TEAM_COP,    -1, 0, 0, 0, 0},
{ 86, "Downtown",          "SF", -1870.0,  613.0, -1658.0,  819.0, COP_COLOR,    TEAM_COP,    -1, 0, 0, 0, 0},
{ 87, "Downtown",          "SF", -1659.0,  473.0, -1518.0,  641.0, COP_COLOR,    TEAM_COP,    -1, 0, 0, 0, 0},
{ 88, "Downtown",          "SF", -1659.0,  641.0, -1519.0,  818.0, COP_COLOR,    TEAM_COP,    -1, 0, 0, 0, 0},
{ 89, "Downtown",          "SF", -1720.0,  816.0, -1509.0,  964.0, COP_COLOR,    TEAM_COP,    -1, 0, 0, 0, 0},
{ 90, "Esplanade North",   "SF", -1722.0, 1279.0, -1509.0, 1459.0, NANG_COLOR,   TEAM_NANG,   -1, 0, 0, 0, 0},
{ 91, "Esplanade East",    "SF", -1722.0, 1110.0, -1509.0, 1279.0, NANG_COLOR,   TEAM_NANG,   -1, 0, 0, 0, 0},
{ 92, "Esplanade East",    "SF", -1720.0,  964.0, -1509.0, 1110.0, NANG_COLOR,   TEAM_NANG,   -1, 0, 0, 0, 0},
{ 93, "Esplanade North",   "SF", -1874.0, 1191.0, -1720.0, 1457.0, NANG_COLOR,   TEAM_NANG,   -1, 0, 0, 0, 0},
{ 94, "Financial",         "SF", -1874.0,  967.0, -1720.0, 1191.0, NANG_COLOR,   TEAM_NANG,   -1, 0, 0, 0, 0},
{ 95, "Financial",         "SF", -1873.0,  819.0, -1718.0,  967.0, COP_COLOR,    TEAM_COP,    -1, 0, 0, 0, 0},
{ 96, "Esplanade North",   "SF", -2066.0, 1173.0, -1873.0, 1431.0, NANG_COLOR,   TEAM_NANG,   -1, 0, 0, 0, 0},
{ 97, "Downtown",          "SF", -2069.0,  975.0, -1873.0, 1173.0, NANG_COLOR,   TEAM_NANG,   -1, 0, 0, 0, 0},
{ 98, "Downtown",          "SF", -2065.0,  817.0, -1871.0,  975.0, COP_COLOR,    TEAM_COP,    -1, 0, 0, 0, 0}
};

new TurfInfo[ MAX_TURFS ][ MAX_TEAMS ][ tinfo ];

//============================= AMMUNATION STUFF ===============================
#define CP_AMMU    0
#define CP_AMMU_2  1
#define CP_AMMU_3  2
#define CP_AMMU_4  3
#define CP_AMMU_5  4
#define CP_LSAP    5
#define CP_LVAP    6
#define CP_SFAP    7
#define CP_LSTS    8
#define CP_LVTS    9
#define CP_SFTS    10

#define MAX_POINTS 11

new Float:checkCoords[ MAX_POINTS ][ 4 ] = {
{ 284.2472,  -41.8122,   300.0394,  -31.2338 }, //Ammunation
{ 284.0852, -112.7093,   298.1693, -102.9225 }, //Ammunation_2
{ 284.2428,  -41.7024,   298.5352,  -30.2174 }, //Ammunation_3
{ 283.7986,  -87.0,      303.2378,  -56.4547 }, //Ammunation_4
{ 284.3799,  -41.8004,   300.0397,  -29.8409 }, //Ammunation_5
{ 1250.286, -2416.142,  1946.205,  -2179.277 }, // LS Airport
{ 1560.399,  1163.809,  1806.404,   1732.415 }, // LV Airport
{-1962.062, -711.7214, -1208.838,  -179.1512 }, // SF Airport
{ 1615.359, -2041.106,  1957.614,  -1788.451 }, // LS Train Station
{ 2599.088,  1210.226,  2888.047,   1519.671 }, // LV Train Station
{-2020.002,  77.27145, -1904.122,   250.8499 }  // SF Train Station
};

new Float:checkpoints[ MAX_POINTS ][ 4 ] = {
{  289.9959,   -40.4220, 1001.5156, 3.0},
{  296.3686,  -105.0054, 1001.5156, 3.0},
{  292.1051,   -32.5395, 1001.5156, 3.0},
{  290.9599,   -84.0210, 1001.5156, 3.0},
{  289.7238,   -39.5351, 1001.5156, 3.0},
{ 1685.7856, -2241.0706,   13.5469, 3.0},
{ 1675.2448,  1447.9196,   10.7880, 3.0},
{-1410.4764,  -299.3061,   14.1484, 3.0},
{ 1746.8268, -1945.2798,   13.5635, 3.0},
{ 2839.6914,  1324.6437,   11.3906, 3.0},
{-1973.4014,   118.6048,   27.6875, 3.0}
};

new checkpointType[ MAX_POINTS ] = {
	CP_AMMU,
	CP_AMMU_2,
	CP_AMMU_3,
	CP_AMMU_4,
	CP_AMMU_5,
	CP_LSAP,
	CP_LVAP,
	CP_SFAP,
	CP_LSTS,
	CP_LVTS,
	CP_SFTS
};

#define MAX_WEAPONS 14
new weaponNames[ MAX_WEAPONS ][ 32 ] = {
	"Pistol",
	"Silenced Pistol",
	"Desert Eagle",
	"Shotgun",
	"Combat Shotgun",
	"Micro Uzi",
	"Tec9",
	"MP5",
	"AK47",
	"M4",
	"Sniper Rifle",
	"Grenade",
	"Molotov",
	"Chainsaw"
};
new weaponIDs[ MAX_WEAPONS ] = {
	22,     //Pistol
	23,     //Silenced Pistol
	24,     //Desert Eagle
	25,     //Shotgun
	27,     //Combat shotgun
	28,     //Micro Uzi
	32,     //Tec9
	29,     //MP5
	30,     //AK47
	31,     //M4
	34,     //Sniper Rifle
	16,     //Grenade
	18,     //Molotov
	 9      //Chainsaw
};
new weaponCost[ MAX_WEAPONS ] = {
	 5000,
	 6000,
	10000,
    10000,
	25000,
	17500,
    15000,
	12500,
	25000,
	27500,
	22500,
	20000,
	20000,
     7500
};
new weaponAmmo[ MAX_WEAPONS ] = {
	100,
   	 50,
	 50,
	 30,
	 30,
	100,
	100,
	100,
	100,
	100,
	 15,
 	  5,
	  5,
	  1
};
new playerWeapons[ SLOTS ][ MAX_WEAPONS ];

//=========================== SPAWNPOINTS ======================================
new Float:gAztecaSP[ 5 ][ 4 ] = {
{1782.4652, -2125.8149, 14.0679,   2.1458},
{1802.0015, -2099.5906, 14.0210, 178.8617},
{1733.7253, -2098.3542, 14.0366, 179.5071},
{1674.3099, -2122.3008, 14.1460, 309.0879},
{1734.5999, -2129.7507, 14.0210, 359.1053}
};

new Float:gVagosSP[ 5 ][ 4 ] = {
{2626.2966, -1112.7968, 67.8459, 268.0490},
{2628.5859, -1068.0347, 69.6129, 270.7647},
{2576.2104, -1070.5781, 69.8322,  90.3136},
{2526.9141, -1061.0150, 69.5673, 276.0494},
{2579.2810, -1033.8696, 69.5804, 182.8840}
};

new Float:gBallaSP[ 5 ][ 4 ] = {
{1999.8577, -1114.6553, 27.1250, 182.0473},
{2022.9449, -1120.9398, 26.4210, 176.7813},
{2045.8439, -1115.7263, 26.3617, 273.3338},
{2093.7844, -1123.7844, 27.6899,  85.9610},
{2094.6392, -1145.1943, 26.5929,  90.0567}
};

new Float:gGroveSP[ 5 ][ 4 ] = {
{2486.3970, -1645.1057, 14.0772, 179.9111},
{2522.4792, -1678.8976, 15.4970,  84.5245},
{2459.4883, -1690.7766, 13.5447,   4.4374},
{2512.8555, -1650.1726, 14.3557, 144.0457},
{2452.1179, -1642.6036, 13.7357, 185.5197}
};

new Float:gHoodlumSP[ 5 ][ 4 ] = {
{2751.8059, -1962.7186, 13.5469, 275.6328},
{2786.4072, -1926.2677, 13.5469,  93.7698},
{2801.9312, -1962.5712, 13.5469, 265.4980},
{2736.3562, -1926.6581, 13.5469,  88.0278},
{2782.5354, -2020.5160, 13.5620,  18.5249}
};

new Float:gRifaSP[ 3 ][ 4 ] = {
{-2434.0842, -60.8489, 35.1054, 172.9666},
{-2439.8081, -79.5686, 34.6864, 353.1886},
{-2460.4290, -60.8048, 32.4068, 180.1215}
};

new Float:gTriadSP[ 3 ][ 4 ] = {
{-2178.3086, 613.4326, 35.1641, 136.9226},
{-2201.1045, 614.2569, 35.1641, 182.2515},
{-2175.0996, 634.8960, 49.4375,  57.4501}
};

new Float:gNangSP[ 3 ][ 4 ] = {
{-1666.9871, 1361.4226, 7.1722,  43.9271},
{-1660.8289, 1384.3992, 9.8047, 139.0468},
{-1644.7908, 1403.0134, 9.8047, 138.0704}
};

new Float:gWorkerSP[ 3 ][ 4 ] = {
{-2072.1418, 225.6616, 36.0343,  86.1656},
{-2074.6448, 267.5142, 35.3569, 186.7060},
{-2099.6152, 257.8746, 36.1625,  84.0517}
};

new Float:gCopSP[ 3 ][ 4 ] = {
{-1619.6704, 692.4329,  7.1875,  95.4340},
{-1591.9252, 716.1388, -5.2422,  99.4878},
{-1637.7950, 667.4746,  7.1875, 266.4874}
};

new Float:gGuardSP[ 3 ][ 4 ] = {
{1319.0714, 1249.9614, 10.8203, 359.8904},
{1318.5450, 1250.8882, 14.2656,   1.4068},
{1347.5579, 1258.2953, 10.8203, 308.1222}
};

new Float:gBikerSP[ 3 ][ 4 ] = {
{2438.3364, 2063.8459, 10.8203, 180.7765},
{2444.7305, 2064.5317, 10.8203, 110.3406},
{2420.2061, 2064.7327, 10.8203, 179.4037}
};

new Float:gMafiaSP[ 3 ][ 4 ] = {
{2179.0608, 1721.8046, 11.0469, 118.3718},
{2159.9807, 1638.6989, 11.1569, 342.6421},
{2196.3025, 1670.0936, 12.3672,  89.5648}
};

new Float:gFanclubSP[ 3 ][ 4 ] = {
{2184.0154, 1115.2419, 12.6484,  60.9775},
{2156.0867, 1129.1124, 12.6484, 243.2986},
{2179.6335, 1110.2701, 12.6484,  33.1532}
};

new Float:gMechanicSP[ 3 ][ 4 ] = {
{1643.1450, 2354.5815, 10.8130,  93.8237},
{1643.2260, 2308.1184, 10.8203,  95.2967},
{1676.6885, 2322.5818, 10.8203, 266.8212}
};

//==============================================================================
forward TimeUpdate( );
forward MoneyTimer( );
forward GameModeExitFunc( );
forward getCheckpointType( playerID );
forward isPlayerInArea( playerID, Float:data[ 4 ] );
forward IsPlayerInTurf( playerid, Float:min_x, Float:min_y, Float:max_x, Float:max_y );
forward checkpointUpdate( );
forward SavedUpdate( );
forward TeamFix( );
forward CheckPlayers( );
forward StartWar( turf, attacker );
forward EndWar( turf, attacker, defender );
forward PickupDestroy( pickupid );
forward TimeTextForPlayer( playerid, Text:text, time );
forward DestroyTextTimer( Text:text );
forward GameModeInitExitFunc( );
forward OnPlayerTeamPrivmsg( playerid, msg[] );
forward SendAdminMessage( color, string[] );

//==============================================================================
#define MAX_SAVE 64
new savedInfo[ MAX_SAVE ][ 3 ];
new savedNames[ MAX_SAVE ][ MAX_PLAYER_NAME ];
new savedWeapons[ MAX_SAVE ][ MAX_WEAPONS ];

//==============================================================================
main()
{
    print("\n\n-----------------------------------------\n");
	print("------       SATW Ultimate v1      ------\n");
	print("------           By Popo           ------\n");
	print("-----------------------------------------\n\n");
	worldTime = 12;
}
//==============================================================================

public TimeUpdate( ) {
	worldTime++;
	worldTime%=24;
	SetWorldTime( worldTime );
}
//==============================================================================

public OnGameModeInit( )
{
    SetGameModeText( "SATW Ultimate v1" );
    SetTeamCount( 15 );
    ShowPlayerMarkers( 1 );
    ShowNameTags( 1 );
    EnableZoneNames( 1 );
    EnableTirePopping( 1 );
    UsePlayerPedAnims( );
    AllowAdminTeleport( 1 );
//    SetDisabledWeapons( 8,10,11,12,13,14,17,19,20,21,35,36,37,38,39,40,41,42,43,44,45 );
    
    // PlayerClasses
    // Azteca //
    AddPlayerClassEx(0, 115, 1782.4652, -2125.8149, 14.0679,   2.1458, 24,100, 27,100, 16,5);
    AddPlayerClassEx(0, 116, 1802.0015, -2099.5906, 14.0210, 178.8617, 24,100, 27,100, 16,5);
    // Vagos //
    AddPlayerClassEx(1, 109, 2626.2966, -1112.7968, 67.8459, 268.0490, 24,100, 27,100, 16,5);
    AddPlayerClassEx(1, 110, 2628.5859, -1068.0347, 69.6129, 270.7647, 24,100, 27,100, 16,5);
    // Balla //
    AddPlayerClassEx(2, 102, 1999.8577, -1114.6553, 27.1250, 182.0473, 24,100, 27,100, 16,5);
    AddPlayerClassEx(2, 104, 2022.9449, -1120.9398, 26.4210, 176.7813, 24,100, 27,100, 16,5);
    // Grove //
    AddPlayerClassEx(3, 270, 2486.3970, -1645.1057, 14.0772, 179.9111, 24,100, 27,100, 16,5);
    AddPlayerClassEx(3, 271, 2522.4792, -1678.8976, 15.4970,  84.5245, 24,100, 27,100, 16,5);
    // Hoodlum //
    AddPlayerClassEx(4,  21, 2751.8059, -1962.7186, 13.5469, 275.6328, 24,100, 27,100, 16,5);
    AddPlayerClassEx(4,  22, 2786.4072, -1926.2677, 13.5469,  93.7698, 24,100, 27,100, 16,5);
    // Rifa //
    AddPlayerClassEx(5, 173, -2434.0842, -60.8489, 35.1054, 172.9666, 24,100, 27,100, 16,5);
    AddPlayerClassEx(5, 174, -2439.8081, -79.5686, 34.6864, 353.1886, 24,100, 27,100, 16,5);
    // Triad //
    AddPlayerClassEx(6, 120, -2178.3086, 613.4326, 35.1641, 136.9226, 24,100, 27,100, 16,5);
    AddPlayerClassEx(6, 294, -2201.1045, 614.2569, 35.1641, 182.2515, 24,100, 27,100, 16,5);
    // Nang //
    AddPlayerClassEx(7, 121, -1666.9871, 1361.4226, 7.1722,  43.9271, 24,100, 27,100, 16,5);
    AddPlayerClassEx(7, 122, -1660.8289, 1384.3992, 9.8047, 139.0468, 24,100, 27,100, 16,5);
    // Worker //
    AddPlayerClassEx(8,  27, -2072.1418, 225.6616, 36.0343,  86.1656, 24,100, 27,100, 16,5);
    AddPlayerClassEx(8, 260, -2074.6448, 267.5142, 35.3569, 186.7060, 24,100, 27,100, 16,5);
    // Cop //
    AddPlayerClassEx(9, 265, -1619.6704, 692.4329,  7.1875,  95.4340, 24,100, 27,100, 16,5);
    AddPlayerClassEx(9, 285, -1637.7950, 667.4746,  7.1875, 266.4874, 24,100, 27,100, 16,5);
    // Guard //
    AddPlayerClassEx(10, 163, 1319.0714,  1249.9614, 10.8203, 359.8904, 24,100, 27,100, 16,5);
    AddPlayerClassEx(10, 164, 1347.5579,  1258.2953, 10.8203, 308.1222, 24,100, 27,100, 16,5);
    // Biker //
    AddPlayerClassEx(11, 100, 2438.3364, 2063.8459, 10.8203, 180.7765, 24,100, 27,100, 16,5);
    AddPlayerClassEx(11, 247, 2159.9807, 1638.6989, 11.1569, 342.6421, 24,100, 27,100, 16,5);
    // Mafia //
    AddPlayerClassEx(12, 113, 2179.0608,  1721.8046, 11.0469, 118.3718, 24,100, 27,100, 16,5);
    AddPlayerClassEx(12, 124, 2196.3025,  1670.0936, 12.3672,  89.564,  24,100, 27,100, 16,5);
    // Elvis Fanclub //
    AddPlayerClassEx(13, 82, 2184.0154, 1115.2419, 12.6484,  60.9775, 24,100, 27,100, 16,5);
    AddPlayerClassEx(13, 84, 2156.0867, 1129.1124, 12.6484, 243.2986, 24,100, 27,100, 16,5);
    // Mechanic //
    AddPlayerClassEx(14, 50,  1643.1450,  2354.5815, 10.8130,  93.8237, 24,100, 27,100, 16,5);
    AddPlayerClassEx(14, 268, 1676.6885,  2322.5818, 10.8203, 266.8212, 24,100, 27,100, 16,5);

//---------------------------- Team Vehicles -----------------------------------
    // Heli's Respawn after 30 secs
    AddStaticVehicleEx(487,  1802.5719, -2147.0588, 17.7954,  87.9824,  97, 1, 30); // azt
    AddStaticVehicleEx(487,  1715.4847, -2144.8665, 17.4541, 271.2545,  97, 1, 30);
    AddStaticVehicleEx(487,  2579.1829, -1030.6965, 73.3895, 268.4893,   6, 1, 30); // vag
    AddStaticVehicleEx(487,  2596.3777, -1117.7544, 66.8571, 345.4225,   6, 1, 30);
    AddStaticVehicleEx(487,  2040.1948, -1113.9559, 30.0394, 269.5649,  54, 1, 30); // bal
    AddStaticVehicleEx(487,  2098.3293, -1186.9663, 30.7324,  90.5505,  54, 1, 30);
    AddStaticVehicleEx(487,  2529.1804, -1678.0981, 20.1069,  90.5616,  86, 1, 30); // gro
    AddStaticVehicleEx(487,  2376.1848, -1642.3527, 13.6877, 179.3587,  86, 1, 30);
    AddStaticVehicleEx(487,  2744.1221, -1961.5730, 21.7922, 359.9515, 113, 1, 30); // hoo
    AddStaticVehicleEx(487,  2794.3784, -1925.2078, 21.7925, 179.7559, 113, 1, 30);
    AddStaticVehicleEx(487, -2484.7693,  -175.7977, 25.7935, 132.1685,  97, 1, 30); // rif
    AddStaticVehicleEx(487, -2483.7014,  -190.8004, 25.7939, 137.8591,  97, 1, 30);
    AddStaticVehicleEx(487, -2245.2288,   540.4937, 35.2921, 268.6438,  85, 1, 30); // tri
    AddStaticVehicleEx(487, -2254.1890,   526.6125, 35.3069, 267.5574,  85, 1, 30);
    AddStaticVehicleEx(487, -1638.4022,  1415.1715,  7.3643, 136.0909,  70, 1, 30); // nan
    AddStaticVehicleEx(487, -1680.6702,  1340.2914, 17.4180, 133.9066,  70, 1, 30);
    AddStaticVehicleEx(487, -2127.4253,   149.3507, 41.4881, 270.7968,  51, 1, 30); // wor
    AddStaticVehicleEx(487, -2087.6904,   302.1537, 41.2709, 181.0328,  51, 1, 30);
    AddStaticVehicleEx(497, -1685.3844,   706.9099, 30.7638, 179.5478,   0, 1, 30); // cop
    AddStaticVehicleEx(497, -1674.5522,   704.8143, 30.7738,   1.0487,   0, 1, 30);
    AddStaticVehicleEx(487,  1336.3990,  1394.6494, 10.9821, 179.0552,  25, 1, 30); // gua
    AddStaticVehicleEx(487,  1318.2394,  1395.8021, 10.9817, 179.2237,  25, 1, 30);
    AddStaticVehicleEx(487,  2488.0244,  2021.7863, 16.2634, 268.9205,  61, 1, 30); // bik
    AddStaticVehicleEx(487,  2468.6418,  2017.4414, 16.2658, 358.4074,  61, 1, 30);
    AddStaticVehicleEx(487,  2106.8057,  1700.3757, 10.9984,  80.2791, 118, 1, 30); // maf
    AddStaticVehicleEx(487,  2107.7715,  1665.7871, 10.9947,  83.9861, 118, 1, 30);
    AddStaticVehicleEx(487,  2151.8806,  1054.7625, 10.9962, 134.2431,  68, 1, 30); // elv
    AddStaticVehicleEx(487,  2130.8623,  1043.0901, 10.9956, 125.6832,  68, 1, 30);
    AddStaticVehicleEx(487,  1749.3252,  2322.5454, 22.9951, 359.9763,  65, 1, 30); // mec
    AddStaticVehicleEx(487,  1587.0514,  2309.1589, 18.9949, 270.2853,  65, 1, 30);
    
    // Cars Respawn after 30 secs
    // Azteca //
    AddStaticVehicleEx(466, 1705.0120, -2128.7627, 13.2887, 359.7284, 97, 96, 30); 
    AddStaticVehicleEx(474, 1667.9630, -2111.1350, 13.3098, 269.6416, 97, 96, 30); 
    AddStaticVehicleEx(575, 1724.8003, -2097.8608, 13.1508, 179.8669, 97, 96, 30);
    AddStaticVehicleEx(466, 1773.0240, -2097.1389, 13.2892, 180.2724, 97, 96, 30); 
    AddStaticVehicleEx(474, 1744.9988, -2127.5525, 13.3096, 359.7272, 97, 96, 30);
    AddStaticVehicleEx(567, 1793.4592, -2129.3376, 13.4168, 359.8183,  3,  3, 30); 
    AddStaticVehicleEx(471, 1772.1758, -2125.4370, 13.0279, 359.0490, 96, 97, 30); 
    // Vagos //
    AddStaticVehicleEx(467, 2570.5310, -1032.9722, 69.3204, 177.8111, 6, 1, 30); 
    AddStaticVehicleEx(474, 2604.4324, -1069.1321, 69.3482,   6.8428, 6, 1, 30); 
    AddStaticVehicleEx(467, 2596.6460, -1077.2358, 69.3248, 180.5385, 6, 1, 30);
    AddStaticVehicleEx(576, 2530.5186, -1065.2362, 69.1801,   0.7576, 6, 1, 30); 
    AddStaticVehicleEx(471, 2629.8889, -1094.3588, 69.0961, 215.4930, 1, 6, 30); 
    AddStaticVehicleEx(576, 2535.4871, -1030.2832, 69.1921, 178.4364, 6, 1, 30); 
    // Balla //
    AddStaticVehicleEx(566, 2050.7302, -1112.2198, 25.2511, 179.3903, 54, 96, 30); 
    AddStaticVehicleEx(517, 2092.5071, -1141.2423, 25.4409,  90.3768, 54, 96, 30); 
    AddStaticVehicleEx(517, 1997.4957, -1119.4990, 26.6240, 238.9880, 54, 96, 30); 
    AddStaticVehicleEx(566, 2014.4319, -1101.7258, 24.6692,  73.8224, 54, 96, 30); 
    AddStaticVehicleEx(471, 2090.8159, -1171.1304, 25.0758,  88.2568, 96, 54, 30); 
    // Grove //
    AddStaticVehicleEx(492, 2508.3440, -1666.1531, 13.1820,  11.7864, 100, 96, 30); 
    AddStaticVehicleEx(600, 2473.1553, -1691.6614, 13.2278, 359.3989, 113, 96, 30); 
    AddStaticVehicleEx(567, 2443.2261, -1643.5012, 13.3333, 178.8905,  86, 96, 30); 
    AddStaticVehicleEx(412, 2486.0669, -1654.5834, 13.2305,  89.3584,  86, 96, 30); 
    AddStaticVehicleEx(471, 2507.9875, -1650.4827, 13.2595, 136.9348,  96, 86, 30); 
    AddStaticVehicleEx(412, 2479.0452, -1748.4788, 13.3856, 359.3116,  86, 96, 30); 
    // Hoodlum //
    AddStaticVehicleEx(567, 2684.5813, -1990.4877, 13.4226, 180.7511, 113,  96, 30); 
    AddStaticVehicleEx(534, 2787.6191, -1992.1963, 13.1642,  90.1024, 113,  96, 30); 
    AddStaticVehicleEx(492, 2774.2568, -1930.2064, 13.2658, 359.4717, 113,  96, 30); 
    AddStaticVehicleEx(535, 2764.6045, -1958.2736, 13.1780, 180.1994, 113,  96, 30); 
    AddStaticVehicleEx(471, 2735.1990, -1936.2517, 13.0279,  89.0335,  96, 113, 30); 
    AddStaticVehicleEx(536, 2772.9712, -1875.9406,  9.5048, 359.7028, 113,  96, 30);
    // Rifa //
    AddStaticVehicleEx(522, -2462.7368, -139.0124, 25.2726, 358.2055, 97, 96, 30);
    AddStaticVehicleEx(475, -2460.7556,  -20.8148, 32.6797, 269.7706, 97, 96, 30);
    AddStaticVehicleEx(439, -2460.6614,  -26.7150, 32.6797, 270.2597, 97, 96, 30);
    AddStaticVehicleEx(536, -2460.7312,   -5.3847, 27.8125, 268.6935, 97, 96, 30);
    AddStaticVehicleEx(560, -2460.6538,  -11.4341, 27.9520, 271.3007, 97, 96, 30);
    // Triad //
    AddStaticVehicleEx(562, -2214.0498, 615.8829, 34.9660, 179.9289, 85, 85, 30);
    AddStaticVehicleEx(458, -2180.3149, 609.9060, 34.9686,  92.7498, 85, 85, 30);
    AddStaticVehicleEx(458, -2213.1521, 581.0363, 34.9662, 180.2130, 85, 85, 30);
    AddStaticVehicleEx(560, -2203.0027, 573.8403, 34.8941,  89.9679, 85, 85, 30);
    AddStaticVehicleEx(522, -2188.5000, 604.9572, 34.7277,  32.8348, 85, 85, 30);
    // Da Nang //
    AddStaticVehicleEx(561, -1652.1877, 1311.2742, 6.7389, 313.8975, 70, 70, 30);
    AddStaticVehicleEx(541, -1637.6150, 1297.5367, 6.7408, 135.1290, 70, 70, 30);
    AddStaticVehicleEx(589, -1741.6249, 1426.5756, 6.8929, 177.5992, 70, 70, 30);
    AddStaticVehicleEx(560, -1706.8154, 1349.8043, 6.8850, 136.0684, 70, 70, 30);
    AddStaticVehicleEx(522, -1671.3358, 1372.3503, 6.7402, 137.0255, 70, 70, 30);
    // Worker //
    AddStaticVehicleEx(522, -2118.9229, 194.8201, 34.7707,   2.9151, 51,  51, 30);
    AddStaticVehicleEx(552, -2036.5442, 305.6420, 34.9265, 359.8398, 51,  51, 30);
    AddStaticVehicleEx(561, -2087.8135, 255.8136, 36.0376, 358.2530, 51,  51, 30);
    AddStaticVehicleEx(560, -2129.8296, 288.1088, 34.7684, 269.9677, 51,  51, 30);
    AddStaticVehicleEx(475, -2132.0894, 160.2040, 35.1602, 271.9636, 51,  51, 30);
    // Cop //
	AddStaticVehicleEx(597, -1611.9730, 673.5499, 6.9567, 181.6088, 0, 1, 30);
    AddStaticVehicleEx(597, -1628.6875, 652.5107, 6.9568,   0.9097, 0, 1, 30);
    AddStaticVehicleEx(597, -1616.7957, 652.5980, 6.9551,   0.6199, 0, 1, 30);
    AddStaticVehicleEx(597, -1594.2644, 672.5858, 6.9564, 176.7420, 0, 1, 30);
    AddStaticVehicleEx(523, -1593.5823, 652.3891, 6.9567,   1.3142, 0, 0, 30);
    // Guards //
    AddStaticVehicleEx(507, 1282.0669, 1306.9561, 10.6463, 269.3059, 25, 96, 30); 
    AddStaticVehicleEx(560, 1328.7433, 1278.8710, 10.6462,   0.4769, 25, 96, 30);
    AddStaticVehicleEx(426, 1306.3514, 1278.9878, 10.5631, 359.8711, 25, 96, 30);
    AddStaticVehicleEx(561, 1282.2550, 1287.6993, 10.5637, 270.1798, 25, 96, 30);
    AddStaticVehicleEx(522, 1281.8011, 1297.3838, 10.3011, 270.9142, 25, 96, 30); 
    // Biker //
    AddStaticVehicleEx(463, 2441.2410, 2009.3234, 10.6953, 270.0854, 61, 61, 30);
    AddStaticVehicleEx(463, 2481.4868, 1991.0804, 10.6953, 359.6107, 61, 61, 30);
    AddStaticVehicleEx(560, 2458.5281, 1990.7748, 10.6953, 359.6424, 61, 61, 30);
    AddStaticVehicleEx(522, 2534.3242, 2014.5380, 10.6953,  89.7622, 61, 61, 30);
    AddStaticVehicleEx(561, 2588.3052, 2056.8210, 10.6953,  90.1378, 61, 61, 30);
    // Mafia //
    AddStaticVehicleEx(405, 2150.2361, 1660.1317, 10.5625, 313.2410, 118, 96, 30);
    AddStaticVehicleEx(405, 2151.8452, 1700.8228, 10.5625,  42.1650, 118, 96, 30);
    AddStaticVehicleEx(405, 2161.4370, 1680.0216, 10.6263, 357.3232, 118, 96, 30);
    AddStaticVehicleEx(522, 2181.1252, 1695.9106, 10.5431,  83.6429, 118, 96, 30);
    AddStaticVehicleEx(522, 2181.0647, 1661.0083, 10.5427,  91.5100, 118, 96, 30);
    // Fanclub //
    AddStaticVehicleEx(560, 2132.7085, 1025.6569, 10.6953,  90.7237, 68, 96, 30);
    AddStaticVehicleEx(522, 2135.4717,  987.6805, 10.6986, 179.0982, 68, 96, 30);
    AddStaticVehicleEx(561, 2171.8625, 1019.4073, 10.6953,  91.4832, 68, 96, 30);
    AddStaticVehicleEx(522, 2141.6189, 1013.0945, 10.6953,  90.9674, 68, 96, 30);
    AddStaticVehicleEx(561, 2185.8804,  987.8866, 10.6953, 359.9317, 68, 96, 30);
    // Mechanics //
    AddStaticVehicleEx(525, 1639.4199, 2328.7297, 10.6923,  90.9605, 65, 96, 30); 
    AddStaticVehicleEx(560, 1679.7505, 2346.5483, 10.6997, 269.7509, 65, 96, 30); 
    AddStaticVehicleEx(443, 1611.4357, 2372.2520, 11.4540, 179.9929, 65, 96, 30); 
    AddStaticVehicleEx(552, 1592.0648, 2294.2043, 10.5116, 270.0344, 65, 96, 30); 
    AddStaticVehicleEx(482, 1679.9426, 2328.4780, 10.9376, 269.2670, 65, 96, 30);
    AddStaticVehicleEx(522, 1641.7880, 2368.5952, 10.3020, 143.0194, 65, 96, 30);
    
//--------------------------------- Random Vehicles ----------------------------
    // Respawn after 50 secs except airplanes those are 30 secs
    AddStaticVehicleEx(420,1691.5933,-2250.2534,13.1612,90.2945, 6, 1, 30); // taxi_6
    AddStaticVehicleEx(420,1674.1932,-2322.7227,13.1630,269.8391, 6, 1, 30);
    AddStaticVehicleEx(420,1674.1003,-2250.3501,13.1667,90.1439, 6, 1, 30);
    AddStaticVehicleEx(420,1691.7648,-2322.7720,13.1621,269.8393, 6, 1, 30);
    AddStaticVehicleEx(420,1770.0873,-1858.5646,13.1937,268.7816, 6, 1, 30);
    AddStaticVehicleEx(420,1788.8662,-1858.6281,13.1919,270.1849, 6, 1, 30);
    AddStaticVehicleEx(487,1914.1748,-2312.5337,13.7206,270.0755,-1,-1, 30); // heli_2
    AddStaticVehicleEx(487,1915.9856,-2293.2664,13.7182,268.3549,-1,-1, 30);
    AddStaticVehicleEx(592,1488.6454,-2593.2637,14.7407,270.0806, 1, 1, 30); // andromada_1
    AddStaticVehicleEx(519,1823.1643,-2630.5415,14.4654,359.6695, 1, 1, 30); // shamal_2
    AddStaticVehicleEx(519,1889.6864,-2629.3171,14.4656,359.4183, 1, 1, 30);
    AddStaticVehicleEx(513,1856.8051,-2411.1489,14.1093,197.3260, -1, -1, 30); // stuntplane_1
    AddStaticVehicleEx(553,1941.2543,-2451.5334,14.8658,128.1360, -1, -1, 30); // nevada_2
    AddStaticVehicleEx(476,2124.6965,-2458.1074,14.2599,120.1050, -1, -1, 30); // rustler_2
    AddStaticVehicleEx(476,1984.8978,-2638.3120,14.2599,65.0431, -1, -1, 30);
    AddStaticVehicleEx(515,2001.9824,-1940.0975,14.3743,270.7258,-1,-1,50); // roadtrain_4
    AddStaticVehicleEx(515,2206.9868,-2522.4387,14.5869,269.8065,-1,-1,50);
    AddStaticVehicleEx(515,2099.6655,-2077.5313,14.5885,180.8334,-1,-1,50);
    AddStaticVehicleEx(515,2432.8206,-2109.6555,14.5652,359.6463,-1,-1,50);
    AddStaticVehicleEx(450,2061.0474,-1939.7745,13.2006,90.2122,-1,-1,50); // trailer_5
    AddStaticVehicleEx(435,2027.0923,-1939.9590,13.2064,269.6728,-1,-1,50);
    AddStaticVehicleEx(591,2458.3452,-2078.2278,13.2523,180.9549,-1,-1,50);
    AddStaticVehicleEx(450,2282.8433,-2351.3801,13.2523,224.2315,-1,-1,50);
    AddStaticVehicleEx(435,2208.4968,-2597.3840,13.2506,270.0967,-1,-1,50);
    AddStaticVehicleEx(446,2932.6929,-2057.4172,-0.7016,269.0194,-1,-1,50); // squalo_1
    AddStaticVehicleEx(466,2052.0728,-1694.7084,13.2964,270.0654,16,16,50); // glendale_2
    AddStaticVehicleEx(567,2452.3054,-1102.5942,43.0857,357.9726,-1,-1,50);
    AddStaticVehicleEx(542,2327.4827,-1677.3326,14.1673,269.8396,-1,-1,50); // clover_4
    AddStaticVehicleEx(542,2495.2571,-1995.9064,13.2625,179.2733,-1,-1,50);
    AddStaticVehicleEx(542,2411.0503,-1390.7070,24.0663,359.3449,-1,-1,50);
    AddStaticVehicleEx(542,1947.4548,-2120.5735,13.2899,269.9948,-1,-1,50);
    AddStaticVehicleEx(535,1844.4076,-1871.1821,13.1508,359.8899,-1,-1,50); // slamvan_2
    AddStaticVehicleEx(535,2192.6365,-1465.4865,25.3018,270.1690,-1,-1,50);
    AddStaticVehicleEx(536,2373.8125,-1927.3652,13.1202,359.1471,-1,-1,50);// blade_1
    AddStaticVehicleEx(534,1921.1251,-1788.4198,13.1127,268.3328,-1,-1,50); // remington_3
    AddStaticVehicleEx(534,2822.3770,-1553.1898,10.6504,89.9093,-1,-1,50);
    AddStaticVehicleEx(534,2426.5911,-1243.1105,23.8694,359.6307,-1,-1,50);
    AddStaticVehicleEx(576,2817.3174,-1183.5714,24.8551,270.9797,-1,-1,50); // tornado_3
    AddStaticVehicleEx(576,2271.0046,-1032.8309,51.4856,136.4009,-1,-1,50);
    AddStaticVehicleEx(576,2475.3682,-1526.3867,23.6049,359.2925,-1,-1,50);
    AddStaticVehicleEx(566,2196.5745,-1283.0890,24.1231,179.5897,-1,-1,50); // tahoma_3
    AddStaticVehicleEx(566,2052.5330,-1904.4730,13.3282,179.1011,-1,-1,50);
    AddStaticVehicleEx(566,2390.1199,-1718.7175,13.3790,179.2825,-1,-1,50);
    AddStaticVehicleEx(567,2229.7876,-1363.0439,23.8577,90.2294,-1,-1,50); // savanna_4
    AddStaticVehicleEx(567,2805.7119,-1428.5934,16.1224,178.4703,-1,-1,50);
    AddStaticVehicleEx(567,2350.7051,-2000.0120,13.2338,359.9185,-1,-1,50);
    AddStaticVehicleEx(567,2454.1021,-1014.1890,59.6425,176.1889,-1,-1,50);
    AddStaticVehicleEx(589,2694.3064,-1119.9226,69.2362,180.5238,-1,-1,50); // club_3
    AddStaticVehicleEx(589,2164.1445,-1793.6271,13.0189,180.5116,-1,-1,50);
    AddStaticVehicleEx(589,2256.8760,-1939.6943,13.2044,89.4820,-1,-1,50);
    AddStaticVehicleEx(492,1964.9985,-1719.2476,15.7505,359.4735,-1,-1,50); // greenwood_3
    AddStaticVehicleEx(492,1999.4695,-1275.2704,23.6021,180.5423,-1,-1,50);
    AddStaticVehicleEx(492,2613.1377,-2380.0427,13.4068,179.5431,-1,-1,50);
    AddStaticVehicleEx(509,1947.1716,-1991.0991,13.0587,271.1580,-1,-1,50); // bike_6
    AddStaticVehicleEx(509,2130.0039,-1595.3577,13.8617,161.5534,-1,-1,50);
    AddStaticVehicleEx(509,2542.6423,-1354.5869,30.1054,178.9754,-1,-1,50);
    AddStaticVehicleEx(509,2804.7268,-1252.8588,46.4658,142.1307,-1,-1,50);
    AddStaticVehicleEx(509,2023.4795,-962.4792,39.2699,21.0140,-1,-1,50);
    AddStaticVehicleEx(560,1130.0643,-1689.4120,13.3153,180.3318,-1,-1,50); // sultan_3
    AddStaticVehicleEx(560,1040.7117,-1056.4841,31.4088,1.2718,-1,-1,50);
    AddStaticVehicleEx(560,1657.6219,-1089.1050,23.6119,270.4426,-1,-1,50);
    AddStaticVehicleEx(579,981.2479,-1306.9004,13.3182,269.4426,-1,-1,50); // huntley_1
    AddStaticVehicleEx(521,782.0196,-1612.4509,12.9532,270.1972,-1,-1,50); // fcr900_3
    AddStaticVehicleEx(521,1183.8922,-1263.9352,14.7461,181.1518,-1,-1,50);
    AddStaticVehicleEx(521,1712.7981,-1005.5743,23.4843,171.1206,-1,-1,50);
    AddStaticVehicleEx(451,1464.1157,-903.3469,54.5425,0.0953,-1,-1,50); // turismo_1
    AddStaticVehicleEx(411,1193.0533,-1020.2946,32.2740,186.7821,-1,-1,50); // infernus_1
    AddStaticVehicleEx(541,1100.1062,-820.5209,86.5702,115.0450,-1,-1,50); // bullet_2
    AddStaticVehicleEx(541,1640.6359,-1281.9531,14.4353,256.6248,-1,-1,50);
    AddStaticVehicleEx(477,1503.8798,-1321.1948,13.9002,0.7865,-1,-1,50); // zr350_1
    AddStaticVehicleEx(402,1658.9725,-1695.1852,20.2898,180.1059,-1,-1,50); // buffalo_1
    AddStaticVehicleEx(437,1749.3578,-1858.4083,13.5473,270.0417,-1,-1,50); // coach_2
    AddStaticVehicleEx(437,2676.8569,-1673.6639,9.5299,179.6113,-1,-1,50);
    AddStaticVehicleEx(561,1401.4670,-2347.9583,13.3526,359.3793,-1,-1,50); // stratum_2
    AddStaticVehicleEx(561,957.8749,-1449.3049,13.3096,271.0958,-1,-1,50);
    AddStaticVehicleEx(558,1401.4198,-2225.3242,13.1763,179.6696,-1,-1,50); // uranus_1
    AddStaticVehicleEx(500,977.2274,-1847.8711,12.4171,88.1356,-1,-1,50); // mesa_2
    AddStaticVehicleEx(500,741.0170,-1866.4719,4.8683,240.8761,-1,-1,50);
    AddStaticVehicleEx(518,2116.8557,-1783.0336,13.0587,359.6252,-1,-1,50); // buccaneer_2
    AddStaticVehicleEx(518,2398.7065,-1545.8726,23.6661,270.0880,-1,-1,50);
    AddStaticVehicleEx(400,1358.4578,-1752.2974,13.4604,90.1414,-1,-1,50); // landstalker_2
    AddStaticVehicleEx(400,1468.4294,-1232.5582,13.7444,89.0040,-1,-1,50);
    AddStaticVehicleEx(581,2177.1533,-993.3595,62.5770,167.8490,-1,-1,50); // bf400_3
    AddStaticVehicleEx(581,2098.6597,-1359.5281,23.5625,270.9590,-1,-1,50);
    AddStaticVehicleEx(581,1214.8021,-1470.3621,13.1436,90.1879,-1,-1,50);
    AddStaticVehicleEx(481,1946.7832,-1364.9180,18.0948,124.3683,-1,-1,50); // bmx_1
    AddStaticVehicleEx(475,1696.4769,-1508.5443,13.1852,359.2828,-1,-1,50); // sabre_2
    AddStaticVehicleEx(475,1910.5804,-1115.8199,25.4690,179.9177,-1,-1,50);
    AddStaticVehicleEx(455,2174.1794,-2266.8301,13.8141,225.1139,-1,-1,50); // flatbed_2
    AddStaticVehicleEx(455,2506.7410,-2627.9053,14.0830,89.6795,-1,-1,50);
    AddStaticVehicleEx(483,1279.7465,-1815.5831,13.3775,90.2054,-1,-1,50); // camper_3
    AddStaticVehicleEx(483,1951.4786,-1563.3632,13.6084,134.7018,-1,-1,50);
    AddStaticVehicleEx(483,2534.2007,-1474.1321,23.9917,269.1452,-1,-1,50);
    AddStaticVehicleEx(522,1425.6019,-1313.0128,13.1256,359.1056,-1,-1,50); // nrg500_2
    AddStaticVehicleEx(522,1560.6329,-2321.9302,13.1249,268.9026, -1, -1, 50);
    // LV random cars
    AddStaticVehicleEx(420,1720.9055,1485.2368,10.3757,162.6470, 6, 1, 30);
    AddStaticVehicleEx(420,1708.0605,1434.7991,10.2638,178.5080, 6, 1, 30);
    AddStaticVehicleEx(420,1719.8208,1376.7893,10.1975,199.3685, 6, 1, 30);
    AddStaticVehicleEx(420,2805.0769,1335.7847,10.3787, 90.5172, 6, 1, 30);
    AddStaticVehicleEx(420,2778.6492,1295.1202,10.3750,359.6712, 6, 1, 30);
    AddStaticVehicleEx(487,1648.9761,1544.0743,10.9558,1.7503, -1, -1, 30); // heli_2
    AddStaticVehicleEx(487,1619.3892,1545.4564,11.0026,3.1692, -1, -1, 30);
    AddStaticVehicleEx(519,1567.7651,1432.7266,11.7639,87.6332, 1, 1, 30); // shamal
    AddStaticVehicleEx(519,1577.0371,1464.4811,11.7504,82.1295, 1, 1, 30); 
    AddStaticVehicleEx(592,1477.9886,1795.1082,12.0081,179.6844,-1,-1, 30); // andromeda
    AddStaticVehicleEx(476,1319.5229,1621.8610,11.5260,267.9826,-1,-1, 30); //  rustler
    AddStaticVehicleEx(476,1317.4348,1589.4575,11.5424,269.9113,-1,-1, 30); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2764.6052,1268.7112,10.3748,270.6114,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2040.1790,1006.7239,10.3768,181.1336,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2039.9473,1230.0125,10.3772,180.1034,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2116.7114,1408.7888,10.5218,179.2679,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2039.9791,1574.9630,10.3776,179.7182,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2196.1772,1856.5784,10.5252,179.1356,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2103.0679,2066.1201,10.5245,269.5481,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2246.3398,2050.0259,10.5250,269.4362,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2360.6646,2194.8467,10.3932,178.8606,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2592.8987,2267.7803,10.5275,269.4724,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2466.0259,2529.9795,10.5253,181.1442,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2197.7363,2529.3193,10.5250,1.8080,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2009.2693,2453.4446,10.5256,89.7768,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1904.9250,2158.4534,10.5258,184.5541,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1688.9044,2054.6873,11.1238,274.4720,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1599.0804,1850.2664,10.5256,359.8095,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1529.4041,1019.1602,10.5250,3.0256,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1363.3055,1155.9316,10.5252,359.7123,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1085.0986,1795.3335,10.5249,0.1638,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1024.3953,2020.1268,11.0310,90.5236,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],988.8911,2307.1729,11.1449,268.2258,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1025.5698,2012.9149,11.1313,88.4723,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1137.4495,2299.9492,10.5257,272.5962,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1291.1768,2600.6392,10.5252,180.7735,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1546.6332,2579.6309,10.5282,2.2929,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1484.6525,2838.6792,10.5258,0.0912,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],1673.2930,2695.3784,10.5257,3.4651,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2010.9521,2755.3247,10.5256,179.1735,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2142.2747,2802.9045,10.5248,88.6897,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2346.9919,2748.0100,10.5250,268.5543,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2119.9939,2186.8291,10.3772,179.9637,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2302.2498,1437.2576,10.5283,89.3624,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2450.9033,1267.5485,10.5254,179.4764,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2485.4004,936.0994,10.5330,0.0658,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2833.3088,895.0292,10.4626,1.2043,-1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],2845.8352,1374.7167,10.4989,359.5112,-1, -1, 50);
    // SF random cars
    AddStaticVehicleEx(420,-1464.3419,-272.6584,13.7726,74.1283, 6, 1, 30); // taxi
    AddStaticVehicleEx(420,-1433.3550,-287.1309,13.7766,58.0364, 6, 1, 30);
    AddStaticVehicleEx(420,-1401.3455,-319.6590,13.7772,32.0264, 6, 1, 30);
    AddStaticVehicleEx(420,-1387.6243,-350.4023,13.7766,15.2365, 6, 1, 30);
    AddStaticVehicleEx(420,-1994.1053,133.1072,27.3422,359.5190, 6, 1, 30);
    AddStaticVehicleEx(420,-1993.9535,151.2193,27.3415,359.5195, 6, 1, 30);
    AddStaticVehicleEx(487,-1332.0522,-257.3351,14.3024,315.0608,-1,-1,30); // heli_2
    AddStaticVehicleEx(487,-1356.1426,-235.1276,14.3206,315.2701,-1,-1,30);
    AddStaticVehicleEx(519,-1246.5514,-96.7909,15.0672,133.4846, 1, 1, 30); // shamal
    AddStaticVehicleEx(519,-1204.2483,-143.7729,15.0628,135.3526, 1, 1, 30);
    AddStaticVehicleEx(592,-1654.7705,-163.7093,15.3423,316.1986,-1,-1, 30); // andromeda
    AddStaticVehicleEx(476,-1306.8915,-366.7459,14.8755,241.2554,-1,-1, 30); // rustler
    AddStaticVehicleEx(476,-1265.6967,-345.7361,14.8615,217.2960,-1,-1, 30);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2322.6084,-124.9697,35.0172,359.3351, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2064.3469,-84.1525,34.8689,0.1790, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2265.8074,129.0285,34.8763,269.1413, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2214.1748,293.4937,34.8218,178.9362, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2429.5396,741.5254,34.7211,180.4388, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1938.2754,585.3342,34.8250,0.5633, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1488.8270,839.0216,6.8928,90.4778, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1736.9862,1016.0563,17.2909,89.4165, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1798.7975,753.3234,24.5959,359.0375, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1516.8970,1118.6008,6.8915,179.7264, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1659.7797,1212.9103,13.3784,301.9333, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2617.5234,1377.7158,6.8424,0.4680, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2897.7800,1053.6215,31.9727,272.7137, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2637.3420,784.4300,49.6892,0.5777, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2578.8276,625.6740,27.5179,358.0196, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2413.6086,980.8525,45.0022,178.8309, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2047.9507,903.1638,53.4844,2.2677, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1684.3408,415.2204,6.8841,132.4810, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1822.4971,-183.3277,9.1028,0.8733, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2132.1653,-455.6646,35.0407,9.4310, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2749.8135,-295.8280,6.7443,359.4821, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2672.9744,-34.7391,4.0409,359.7040, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2665.0200,267.7721,4.0414,181.2495, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2796.1958,223.7720,6.8922,269.6157, -1, -1, 50); 
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2197.9675,1033.2543,79.8216,181.9314, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2512.9194,1209.5608,37.2357,88.5554, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2531.2158,1140.2029,55.5405,171.7101, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2664.9814,913.0871,79.4882,180.2361, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-1834.9089,112.8296,14.9307,267.4229, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2125.1187,-757.6423,31.8373,90.4483, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2133.8025,-950.2361,31.8371,270.3718, -1, -1, 50);
    AddStaticVehicleEx(randcar[random(sizeof(randcar))],-2411.6138,-585.4703,132.4618,35.0619, -1, -1, 50);

    //
    for (new t=0; t<MAX_TURFS; t++) {
         GangZoneCreate( turfs[ t ][zMinX], turfs[ t ][zMinY], turfs[ t ][zMaxX], turfs[ t ][zMaxY] );
         for (new teams=0; teams<MAX_TEAMS; teams++) TurfInfo[ t ][ teams ][ MIT ]=0;
    }
    //
    for(new x=0; x<=100; x++) gDropPickup[x] = -1;
    
    // Menus
    LSAMenu = CreateMenu( "Travel", 2, 30.0, 170.0, 90.0, 50.0 );
    AddMenuItem( LSAMenu, 0, "To Las Venturas." );
    AddMenuItem( LSAMenu, 0, "To San Fierro." );
    AddMenuItem( LSAMenu, 0, "Exit." );
    AddMenuItem( LSAMenu, 1, "$2500." );
    AddMenuItem( LSAMenu, 1, "$2500." );
    
    LVAMenu = CreateMenu( "Travel", 2, 30.0, 170.0, 90.0, 50.0 );
    AddMenuItem( LVAMenu, 0, "To Los Santos." );
    AddMenuItem( LVAMenu, 0, "To San Fierro." );
    AddMenuItem( LVAMenu, 0, "Exit." );
    AddMenuItem( LVAMenu, 1, "$2500." );
    AddMenuItem( LVAMenu, 1, "$2500." );
    
    SFAMenu = CreateMenu( "Travel", 2, 30.0, 170.0, 90.0, 50.0 );
    AddMenuItem( SFAMenu, 0, "To Los Santos." );
    AddMenuItem( SFAMenu, 0, "To Las Venturas." );
    AddMenuItem( SFAMenu, 0, "Exit." );
    AddMenuItem( SFAMenu, 1, "$2500." );
    AddMenuItem( SFAMenu, 1, "$2500." );
    
    LSTMenu = CreateMenu( "Travel", 2, 30.0, 170.0, 90.0, 50.0 );
    AddMenuItem( LSTMenu, 0, "To Las Venturas." );
    AddMenuItem( LSTMenu, 0, "To San Fierro." );
    AddMenuItem( LSTMenu, 0, "Exit." );
    AddMenuItem( LSTMenu, 1, "$2500." );
    AddMenuItem( LSTMenu, 1, "$2500." );
    
    LVTMenu = CreateMenu( "Travel", 2, 30.0, 170.0, 90.0, 50.0 );
    AddMenuItem( LVTMenu, 0, "To Los Santos." );
    AddMenuItem( LVTMenu, 0, "To San Fierro." );
    AddMenuItem( LVTMenu, 0, "Exit." );
    AddMenuItem( LVTMenu, 1, "$2500." );
    AddMenuItem( LVTMenu, 1, "$2500." );

    SFTMenu = CreateMenu( "Travel", 2, 30.0, 170.0, 90.0, 50.0 );
    AddMenuItem( SFTMenu, 0, "To Los Santos." );
    AddMenuItem( SFTMenu, 0, "To Las Venturas." );
    AddMenuItem( SFTMenu, 0, "Exit." );
    AddMenuItem( SFTMenu, 1, "$2500." );
    AddMenuItem( SFTMenu, 1, "$2500." );

	// Timers
    SetTimer( "MoneyTimer",       1000, 1 );
	SetTimer( "checkpointUpdate", 1100, 1 );
	SetTimer( "CheckPlayers",    10000, 1 );
    SetTimer( "TimeUpdate",      60009, 1 );
    SetTimer( "SavedUpdate",     60017, 1 );
    
    return 1;
}
//==============================================================================

public getCheckpointType( playerID ) {
	return checkpointType[ playerCheckpoint[playerID] ];
}
//==============================================================================

public isPlayerInArea(playerID, Float:data[4])
{
	new Float:X, Float:Y, Float:Z;

	GetPlayerPos(playerID, X, Y, Z);
	if(X >= data[0] && X <= data[2] && Y >= data[1] && Y <= data[3]) {
		return 1;
	}
	return 0;
}
//==============================================================================

public IsPlayerInTurf(playerid,Float:min_x,Float:min_y,Float:max_x,Float:max_y)
{
    new Float:X,Float:Y,Float:Z;
    GetPlayerPos(playerid, X, Y, Z);
    if((X <= max_x && X >= min_x) && (Y <= max_y && Y >= min_y)) return 1;
    return 0;
}
//==============================================================================

public checkpointUpdate( )
{
	for(new i=0; i<SLOTS; i++)
	{
	    if(IsPlayerConnected(i)) {
	        for(new j=0; j < MAX_POINTS; j++) {
	            if(isPlayerInArea(i, checkCoords[j])) {
	                if(playerCheckpoint[i]!=j) {
	                    DisablePlayerCheckpoint(i);
						SetPlayerCheckpoint(i, checkpoints[j][0],checkpoints[j][1],checkpoints[j][2],checkpoints[j][3]);
						playerCheckpoint[i] = j;
					}
	            } else {
	            	if(playerCheckpoint[i]==j) {
	            	    DisablePlayerCheckpoint(i);
	            	    playerCheckpoint[i] = 999;
         	    	}
	            }
	        }
		}
	}
}
//==============================================================================

public SavedUpdate( )
{
	for(new i = 0; i < MAX_SAVE; i++) {
		if(savedInfo[i][2] < 5) {
			if(savedInfo[i][2]==3) {
				savedInfo[i][0]=savedInfo[i][1]=0;
				savedNames[i][0]=0;
			}
			savedInfo[i][2]++;
		}
	}
}
//==============================================================================

public MoneyTimer( )
{
	for ( new playerid = 0, mp = GetMaxPlayers( ); playerid < mp; playerid++ )
	{
	    if ( !IsPlayerConnected( playerid ) )
			continue;

	    new
			pMoney = GetPlayerMoney( playerid );

	    if ( !lSMoney[ playerid ] && pMoney > ( lTMoney[ playerid ] + 1499 ) )
	    {
            GetPlayerPos( playerid, X250[ playerid ], Y250[ playerid ], Z250[ playerid ] );
			if (X250[playerid] >= 1924.0562 && X250[playerid] <= 2019.0679 &&
			    Y250[playerid] >= 967.1267  && Y250[playerid] <= 1029.9370  )
			{
                new tString[ 128 ];
	            GetPlayerName( playerid, tString, MAX_PLAYER_NAME );

                format(
				tString, 128,
				"* %s's (%d) cash just increased by $%d (from $%d to $%d | Location: 4Dragons)",
				tString, playerid,	pMoney - lTMoney[ playerid ],
				lTMoney[ playerid ],pMoney
		  	    );
                SendAdminMessage( COLOR_ORANGE, tString );
			}
            else if (X250[playerid] >= 2147.1572 && X250[playerid] <= 2259.6709 &&
				Y250[playerid] >= 1573.1588 && Y250[playerid] <= 1714.0790  )
			{
                new tString[ 128 ];
	            GetPlayerName( playerid, tString, MAX_PLAYER_NAME );

                format(
				tString, 128,
				"* %s's (%d) cash just increased by $%d (from $%d to $%d | Location: Caligulas)",
				tString, playerid,	pMoney - lTMoney[ playerid ],
				lTMoney[ playerid ],pMoney
		  	    );
                SendAdminMessage( COLOR_ORANGE, tString );
			}
			else {
		        new tString[ 128 ];
	            GetPlayerName( playerid, tString, MAX_PLAYER_NAME );

	            format(
				tString, 128,
				"* %s's (%d) cash just increased by $%d (from $%d to $%d | Location: Unknown)",
				tString, playerid,	pMoney - lTMoney[ playerid ],
				lTMoney[ playerid ],pMoney
			    );
                SendAdminMessage( COLOR_ORANGE, tString );
            }
	    }

	    // Set the last script money to the current
		// real money (to stop the increase showing many times).

	    lTMoney[ playerid ] = pMoney;
	    lSMoney[ playerid ] = 0;
	}
}
//==============================================================================

public OnPlayerConnect( playerid )
{
    new playrname[ MAX_PLAYER_NAME ], string[ 256 ];

    SetPlayerColor( playerid, COLOR_INACTIVE );
    GameTextForPlayer( playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~w~SATW Ultimate v1", 5000, 3 );
	SendClientMessage( playerid, COLOR_RED, "Welcome, type /help for more info." );
	
	GetPlayerName(playerid, playrname, sizeof(playrname));
	format(string, 256, "*** %s(ID: %d) has joined the server.", playrname, playerid);
    SendClientMessageToAll( COLOR_INACTIVE, string );
	
//  SendDeathMessage( INVALID_PLAYER_ID, playerid, 200 ); // Connect message in kill chart
	
    playerCheckpoint[ playerid ] =999;
    AllowPlayerTeleport( playerid, 0 );
    SetPlayerWantedLevel( playerid, 0 );
    TeamKills[ playerid ] =0;
    Spawned [ playerid ] =0;
    ShowPM[ playerid ] =0;
    ShowTPM[ playerid ] =0;
    PlayerOnDuty[ playerid ]=0;
    lTMoney[ playerid ] = 0;
	lSMoney[ playerid ] = 0;


	GetPlayerName(playerid, playrname, sizeof(playrname));
	for(new i = 0; i < MAX_SAVE; i++) {

	    if(isStringSame(savedNames[i], playrname, MAX_PLAYER_NAME)) {
			bounty[playerid] = savedInfo[i][0];

			savedInfo[i][0]=savedInfo[i][1]=0;
			savedNames[i][0]=0;

			for(new j = 0; j < MAX_WEAPONS; j++) {
				playerWeapons[playerid][j]=savedWeapons[i][j];
				savedWeapons[i][j]=0;
			}
		}
	}
	
	for (new i = 0; i < MAX_TURFS; i++) GangZoneShowForPlayer(playerid, turfs[ i ][turfID], turfs[ i ][TurfColor]);
	
    return 1;
}
//==============================================================================

public OnPlayerDisconnect( playerid, reason )
{
    new playername[ MAX_PLAYER_NAME ];

    GetPlayerName(playerid, playername, sizeof(playername));
    SendDeathMessage(INVALID_PLAYER_ID, playerid, 201);

	//Save temp info for timeouts/crashes
	GetPlayerName(playerid, playername, sizeof(playername));
	format(savedNames[savePos], MAX_PLAYER_NAME, "%s",playername);

	savedInfo[savePos][0] = bounty[playerid];
	savedInfo[savePos][1] = 0;
	
	
	for(new i = 0; i < MAX_WEAPONS; i++)
		savedWeapons[savePos][i]=playerWeapons[playerid][i];
	//
	savePos++;
	if(savePos >= MAX_SAVE)
	savePos = 0;
	bounty[playerid] = 0;
	
	for(new i = 0; i < MAX_WEAPONS;i++) {
		playerWeapons[playerid][i]=0;
	}
	
	SetPlayerColor( playerid, COLOR_INACTIVE );
}
//==============================================================================

public OnPlayerRequestClass( playerid, classid )
{
    SetPlayerClass( playerid, classid );
    SetPlayerColor( playerid, COLOR_INACTIVE );
    PlayerPlaySound( playerid, 1068, 0.0, 0.0, 0.0 );

    switch(classid)
    {
       case 0..1:
       {
         SetPlayerPos(playerid, 1810.5295,-2103.0408,13.5469);
         SetPlayerCameraPos(playerid, 1814.3398,-2100.5222,13.5469);
         SetPlayerCameraLookAt(playerid, 1810.5295,-2103.0408,13.5469);
         SetPlayerFacingAngle(playerid, 300.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Azteca", 3000, 3);
         ApplyAnimation(playerid,"RIOT", "RIOT_ANGRY",4.0,1,1,1,1,1);
       }
       case 2..3:
       {
         SetPlayerPos(playerid, 2654.5081,-1063.5448,69.5937);
         SetPlayerCameraPos(playerid, 2658.3940,-1060.7126,69.5209);
         SetPlayerCameraLookAt(playerid, 2654.5081,-1063.5448,69.5937);
         SetPlayerFacingAngle(playerid, 300.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Vagos", 3000, 3);
         ApplyAnimation(playerid,"RIOT", "RIOT_CHANT",4.0,1,1,1,1,1);
       }
       case 4..5:
       {
         SetPlayerPos(playerid, 1979.8929,-1143.1704,25.9858);
         SetPlayerCameraPos(playerid, 1975.8948,-1145.9689,25.9895);
         SetPlayerCameraLookAt(playerid, 1979.8929,-1143.1704,25.9858);
         SetPlayerFacingAngle(playerid, 120.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Balla", 3000, 3);
         ApplyAnimation(playerid,"GHANDS", "gsign2LH",4.0,1,1,1,1,1);
       }
       case 6..7:
       {
         SetPlayerPos(playerid, 2498.2249,-1644.6326,18.8751);
         SetPlayerCameraPos(playerid, 2498.2676,-1640.1935,18.6116);
         SetPlayerCameraLookAt(playerid, 2498.2249,-1644.6326,18.8751);
         SetPlayerFacingAngle(playerid, 0.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Orange Grove Families", 3000, 3);
         ApplyAnimation(playerid,"LOWRIDER", "RAP_B_Loop",4.0,1,1,1,1,1);
       }
       case 8..9:
       {
         SetPlayerPos(playerid, 2785.7817,-1956.1940,20.4537);
         SetPlayerCameraPos(playerid, 2791.5693,-1956.3384,21.3124);
         SetPlayerCameraLookAt(playerid, 2785.7817,-1956.1940,20.4537);
         SetPlayerFacingAngle(playerid, 270.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Hoodlum", 3000, 3);
         ApplyAnimation(playerid,"DEALER", "DEALER_IDLE",4.0,1,1,1,1,1);
       }
       case 10..11:
       {
         SetPlayerPos(playerid, -2446.6492,-78.0747,34.1809);
         SetPlayerCameraPos(playerid, -2445.4675,-83.2549,34.2572);
         SetPlayerCameraLookAt(playerid, -2446.6492,-78.0747,34.1809);
         SetPlayerFacingAngle(playerid, 180.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Rifa", 3000, 3);
         ApplyAnimation(playerid,"GYMNASIUM", "GYMshadowbox",4.0,1,1,1,1,1);
       }
       case 12..13:
       {
         SetPlayerPos(playerid, -2196.6521,608.2758,35.1641);
         SetPlayerCameraPos(playerid, -2199.9006,606.6349,35.1641);
         SetPlayerCameraLookAt(playerid, -2196.6521,608.2758,35.1641);
         SetPlayerFacingAngle(playerid, 110.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Triad", 3000, 3);
         ApplyAnimation(playerid,"GANGS", "Invite_Yes",4.0,1,1,1,1,1);
       }
       case 14..15:
       {
         SetPlayerPos(playerid, -1652.6858,1408.6296,9.8047);
         SetPlayerCameraPos(playerid, -1651.6547,1412.3341,9.8047);
         SetPlayerCameraLookAt(playerid, -1652.6858,1408.6296,9.8047);
         SetPlayerFacingAngle(playerid, -10.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Da Nang", 3000, 3);
         ApplyAnimation(playerid,"LOWRIDER", "RAP_A_Loop",4.0,1,1,1,1,1);
       }
       case 16..17:
       {
         SetPlayerPos(playerid, -2082.2502,230.6593,35.5388);
         SetPlayerCameraPos(playerid, -2085.1948,228.5887,35.6940);
         SetPlayerCameraLookAt(playerid, -2082.2502,230.6593,35.5388);
         SetPlayerFacingAngle(playerid, 130.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Worker", 3000, 3);
         ApplyAnimation(playerid,"COP_AMBIENT", "Coplook_think",4.0,1,1,1,1,1);
       }
       case 18..19:
       {
         SetPlayerPos(playerid, -1627.8352,674.1260,7.1875);
         SetPlayerCameraPos(playerid, -1631.2100,676.1075,7.1875);
         SetPlayerCameraLookAt(playerid, -1627.8352,674.1260,7.1875);
         SetPlayerFacingAngle(playerid, 60.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Cop", 3000, 3);
         ApplyAnimation(playerid,"ped", "ARRESTgun", 4.0, 0, 1, 1, 1, -1);
       }
       case 20..21:
       {
         SetPlayerPos(playerid,1289.1920,1313.4346,17.3299);
         SetPlayerCameraPos(playerid,1287.9818,1315.8494,17.6311);
         SetPlayerCameraLookAt(playerid,1289.1920,1313.4346,17.3299);
         SetPlayerFacingAngle(playerid,30.0);
         GameTextForPlayer( playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Guard", 3000, 3 );
         ApplyAnimation(playerid,"RIOT", "RIOT_ANGRY",4.0,1,1,1,1,1);
       }
       case 22..23:
       {
         SetPlayerPos(playerid,2430.9939,2047.5365,10.8203);
         SetPlayerCameraPos(playerid,2428.7488,2043.9611,10.8203);
         SetPlayerCameraLookAt(playerid,2430.9939,2047.5365,10.8203);
         SetPlayerFacingAngle( playerid, 140.0 );
         GameTextForPlayer( playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Biker", 3000, 3 );
         ApplyAnimation( playerid, "STRIP", "PUN_HOLLER", 4.0, 1, 1, 1, 1, 1 );
       }
       case 24..25:
       {
         SetPlayerPos(playerid,2080.5840,1682.7871,10.8203);
         SetPlayerCameraPos(playerid,2077.9380,1684.2322,10.8203);
         SetPlayerCameraLookAt(playerid,2080.5840,1682.7871,10.8203);
         SetPlayerFacingAngle(playerid,55.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Mafia", 3000, 3);
         ApplyAnimation(playerid,"LOWRIDER", "RAP_B_Loop",4.0,1,1,1,1,1);
       }
       case 26..27:
       {
         SetPlayerPos(playerid,2126.6423,1144.6746,13.5095);
         SetPlayerCameraPos(playerid,2124.0168,1146.0432,13.5092);
         SetPlayerCameraLookAt(playerid,2126.6423,1144.6746,13.5095);
         SetPlayerFacingAngle( playerid, 50.0 );
         GameTextForPlayer( playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Elvis Fanclub", 3000, 3 );
         ApplyAnimation(playerid,"GYMNASIUM", "GYMshadowbox",4.0,1,1,1,1,1);
       }
       case 28..29:
       {
         SetPlayerPos(playerid,1597.1831,2312.2361,18.8222);
         SetPlayerCameraPos(playerid,1594.8032,2311.0300,18.8222);
         SetPlayerCameraLookAt(playerid,1597.1831,2312.2361,18.8222);
         SetPlayerFacingAngle(playerid,110.0);
         GameTextForPlayer(playerid, "~n~~n~~n~~n~~n~~n~~n~~n~~n~~y~Mechanic", 3000, 3);
         ApplyAnimation(playerid,"LOWRIDER", "RAP_A_Loop",4.0,1,1,1,1,1);
       }
    }
    return 1;
}
//==============================================================================

SetPlayerClass(playerid, classid)
{
    switch(classid)
    {
       case 0..1:   gTeam[playerid] = TEAM_AZTECA;
       case 2..3:   gTeam[playerid] = TEAM_VAGOS;
       case 4..5:   gTeam[playerid] = TEAM_BALLA;
       case 6..7:   gTeam[playerid] = TEAM_GROVE;
       case 8..9:   gTeam[playerid] = TEAM_HOODLUM;
       case 10..11: gTeam[playerid] = TEAM_RIFA;
       case 12..13: gTeam[playerid] = TEAM_TRIAD;
       case 14..15: gTeam[playerid] = TEAM_NANG;
       case 16..17: gTeam[playerid] = TEAM_WORKER;
       case 18..19: gTeam[playerid] = TEAM_COP;
       case 20..21: gTeam[playerid] = TEAM_GUARD;
       case 22..23: gTeam[playerid] = TEAM_BIKER;
       case 24..25: gTeam[playerid] = TEAM_MAFIA;
       case 26..27: gTeam[playerid] = TEAM_FANCLUB;
       case 28..29: gTeam[playerid] = TEAM_MECHANIC;
       
    }
}
//==============================================================================

public OnPlayerSpawn(playerid)
{
    new rand = random( 5 );
    SetPlayerInterior( playerid, 0 );
    SetPlayerToTeamColor( playerid );
    TeamFix( );
    SetPlayerHealth( playerid, 100 );
    Spawned[ playerid ] =1;
    FlashZoneForPlayer( playerid );
    PlayerPlaySound( playerid, 1069, 0.0, 0.0, 0.0) ;
    SetCameraBehindPlayer( playerid );

    switch(gTeam[playerid])
    {
       case TEAM_AZTECA: {
         SetPlayerPos(playerid,gAztecaSP[rand][0],gAztecaSP[rand][1],gAztecaSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gAztecaSP[rand][3]);
       }
       case TEAM_VAGOS: {
         SetPlayerPos(playerid,gVagosSP[rand][0],gVagosSP[rand][1],gVagosSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gVagosSP[rand][3]);
       }
       case TEAM_BALLA: {
         SetPlayerPos(playerid,gBallaSP[rand][0],gBallaSP[rand][1],gBallaSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gBallaSP[rand][3]);
       }
       case TEAM_GROVE: {
         SetPlayerPos(playerid,gGroveSP[rand][0],gGroveSP[rand][1],gGroveSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gGroveSP[rand][3]);
       }
       case TEAM_HOODLUM: {
         SetPlayerPos(playerid,gHoodlumSP[rand][0],gHoodlumSP[rand][1],gHoodlumSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gHoodlumSP[rand][3]);
       }
       case TEAM_RIFA: {
         SetPlayerPos(playerid,gRifaSP[rand][0],gRifaSP[rand][1],gRifaSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gRifaSP[rand][3]);
       }
       case TEAM_TRIAD: {
         SetPlayerPos(playerid,gTriadSP[rand][0],gTriadSP[rand][1],gTriadSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gTriadSP[rand][3]);
       }
       case TEAM_NANG: {
         SetPlayerPos(playerid,gNangSP[rand][0],gNangSP[rand][1],gNangSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gNangSP[rand][3]);
       }
       case TEAM_WORKER: {
         SetPlayerPos(playerid,gWorkerSP[rand][0],gWorkerSP[rand][1],gWorkerSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gWorkerSP[rand][3]);
       }
       case TEAM_COP: {
         SetPlayerPos(playerid,gCopSP[rand][0],gCopSP[rand][1],gCopSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gCopSP[rand][3]);
       }
       case TEAM_GUARD: {
         SetPlayerPos(playerid,gGuardSP[rand][0],gGuardSP[rand][1],gGuardSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gGuardSP[rand][3]);
       }
       case TEAM_BIKER: {
         SetPlayerPos(playerid,gBikerSP[rand][0],gBikerSP[rand][1],gBikerSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gBikerSP[rand][3]);
       }
       case TEAM_MAFIA: {
         SetPlayerPos(playerid,gMafiaSP[rand][0],gMafiaSP[rand][1],gMafiaSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gMafiaSP[rand][3]);
       }
       case TEAM_FANCLUB: {
         SetPlayerPos(playerid,gFanclubSP[rand][0],gFanclubSP[rand][1],gFanclubSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gFanclubSP[rand][3]);
       }
       case TEAM_MECHANIC: {
         SetPlayerPos(playerid,gMechanicSP[rand][0],gMechanicSP[rand][1],gMechanicSP[rand][2]);
	     SetPlayerFacingAngle(playerid,gMechanicSP[rand][3]);
       }
	}

    for (new i = 0; i < MAX_WEAPONS; i++) {
	 	 if (playerWeapons[playerid][ i ] > 0) {
		 	 GivePlayerWeapon(playerid, weaponIDs[ i ], weaponAmmo[ i ]*playerWeapons[playerid][ i ]);
		 }
	}

	if (PlayerOnDuty[playerid] == 1) SetPlayerColor(playerid, COLOR_WHITE);

    return 1;
}
//==============================================================================

SetPlayerToTeamColor(playerid)
{
    switch(gTeam[playerid])
    {
       case TEAM_AZTECA:   SetPlayerColor( playerid, AZTECA_COLOR   );
       case TEAM_VAGOS:    SetPlayerColor( playerid, VAGOS_COLOR    );
       case TEAM_BALLA:    SetPlayerColor( playerid, BALLA_COLOR    );
       case TEAM_GROVE:    SetPlayerColor( playerid, GROVE_COLOR    );
       case TEAM_HOODLUM:  SetPlayerColor( playerid, HOODLUM_COLOR  );
       case TEAM_RIFA:     SetPlayerColor( playerid, RIFA_COLOR     );
       case TEAM_TRIAD:    SetPlayerColor( playerid, TRIAD_COLOR    );
       case TEAM_NANG:     SetPlayerColor( playerid, NANG_COLOR     );
       case TEAM_WORKER:   SetPlayerColor( playerid, WORKER_COLOR   );
       case TEAM_COP:      SetPlayerColor( playerid, COP_COLOR      );
       case TEAM_GUARD:    SetPlayerColor( playerid, GUARD_COLOR    );
       case TEAM_BIKER:    SetPlayerColor( playerid, BIKER_COLOR    );
       case TEAM_MAFIA:    SetPlayerColor( playerid, MAFIA_COLOR    );
       case TEAM_FANCLUB:  SetPlayerColor( playerid, FANCLUB_COLOR  );
       case TEAM_MECHANIC: SetPlayerColor( playerid, MECHANIC_COLOR );
	}
}
//==============================================================================

public TeamFix( )
{
    for (new i; i < SLOTS; i++)
	{
         switch(gTeam[ i ])
         {
            case TEAM_AZTECA:   { SetPlayerTeam( i, 999 ); SetPlayerTeam( i,  0 ); }
            case TEAM_VAGOS:    { SetPlayerTeam( i, 998 ); SetPlayerTeam( i,  1 ); }
            case TEAM_BALLA:    { SetPlayerTeam( i, 997 ); SetPlayerTeam( i,  2 ); }
            case TEAM_GROVE:    { SetPlayerTeam( i, 996 ); SetPlayerTeam( i,  3 ); }
            case TEAM_HOODLUM:  { SetPlayerTeam( i, 995 ); SetPlayerTeam( i,  4 ); }
            case TEAM_RIFA:     { SetPlayerTeam( i, 994 ); SetPlayerTeam( i,  5 ); }
            case TEAM_TRIAD:    { SetPlayerTeam( i, 993 ); SetPlayerTeam( i,  6 ); }
            case TEAM_NANG:     { SetPlayerTeam( i, 992 ); SetPlayerTeam( i,  7 ); }
            case TEAM_WORKER:   { SetPlayerTeam( i, 991 ); SetPlayerTeam( i,  8 ); }
            case TEAM_COP:      { SetPlayerTeam( i, 990 ); SetPlayerTeam( i,  9 ); }
            case TEAM_GUARD:    { SetPlayerTeam( i, 989 ); SetPlayerTeam( i, 10 ); }
            case TEAM_BIKER:    { SetPlayerTeam( i, 988 ); SetPlayerTeam( i, 11 ); }
            case TEAM_MAFIA:    { SetPlayerTeam( i, 987 ); SetPlayerTeam( i, 12 ); }
            case TEAM_FANCLUB:  { SetPlayerTeam( i, 986 ); SetPlayerTeam( i, 13 ); }
            case TEAM_MECHANIC: { SetPlayerTeam( i, 985 ); SetPlayerTeam( i, 14 ); }
	     }
	}
}
//==============================================================================

FlashZoneForPlayer( playerid )
{
    for (new i = 0; i < MAX_TURFS; i++)
	{
         if (turfs[ i ][ TurfWarStarted ] == 1)
         {
			 if (gTeam[playerid] == turfs[ i ][ TurfAttacker ])   GangZoneFlashForPlayer( playerid, i, COLOR_FLASH );
			 else if (gTeam[playerid] == turfs[ i ][ TurfOwner ]) GangZoneFlashForPlayer( playerid, i, COLOR_FLASH );
			 else                                                 GangZoneFlashForPlayer( playerid, i, COLOR_FLASH2 );
		 }
	}
}
//==============================================================================

public OnPlayerDeath( playerid, killerid, reason )
{
    new killedplayer[ MAX_PLAYER_NAME ];
    new Float:x, Float:y, Float:z;
	new string[ 256 ];

   	Spawned[ playerid ] =0;
   	SetPlayerArmour( playerid, 0 );

    if (killerid == INVALID_PLAYER_ID)
	{
	    SendDeathMessage( INVALID_PLAYER_ID, playerid, reason );
	    SetPlayerWantedLevel( playerid, 0 );
	    TeamInfo[ gTeam[playerid] ][ HomiesDied ]++;
	    TeamInfo[ gTeam[playerid] ][ TeamScore ]--;
	}
	else
	{
        SendDeathMessage( killerid, playerid, reason );
        
        #if DROP_WEAPONS
    	if (!GetPlayerInterior(playerid) && !IsPlayerInAnyVehicle(playerid)) DropPlayerWeapons(playerid);
    	#endif
        
        if (gTeam[ killerid ] != gTeam[ playerid ]) // Valid kill
	    {
	      SetPlayerScore( killerid, GetPlayerScore( killerid ) +1 );
		  GivePlayerMoney( killerid, 500 );
          SetPlayerWantedLevel( killerid, GetPlayerWantedLevel( killerid )+1 );
          TeamInfo[ gTeam[killerid] ][ RivalsKilled ]++;
          TeamInfo[ gTeam[playerid] ][ HomiesDied ]++;
          TeamInfo[ gTeam[killerid] ][ TeamScore ]++;
          TeamInfo[ gTeam[playerid] ][ TeamScore ]--;
//----------------------------- player was killed in a turf? -------------------
		  GetPlayerPos(playerid, x, y, z);
		  GetPlayerPos(killerid, x, y, z);
	      for (new i = 0; i < MAX_TURFS; i++)
	      {
	           if (IsPlayerInTurf(playerid, turfs[i][zMinX], turfs[i][zMinY], turfs[i][zMaxX], turfs[i][zMaxY]) &&
			       IsPlayerInTurf(killerid, turfs[i][zMinX], turfs[i][zMinY], turfs[i][zMaxX], turfs[i][zMaxY])  )
	           {
                   if (turfs[ i ][ TurfWarStarted ] != 1 && !IsPlayerInAnyVehicle(killerid))
                   {
                       TurfInfo[ i ][ gTeam[killerid] ][ TurfKills ]++;
                       if (TurfInfo[ i ][ gTeam[killerid] ][ TurfKills ] == ATTACK_KILLS)
                       {
                           if (turfs[ i ][ TurfOwner ] == gTeam[killerid]) {
                               for (new a=0; a<MAX_TEAMS; a++) { TurfInfo[ i ][ a ][ TurfKills ] =0; }
							   return 1;
                           }

                           turfs[ i ][ TurfAttacker ] = gTeam[killerid];
                           for (new b=0; b<SLOTS; b++)
	                       {
                                if (gTeam[ b ] == turfs[ i ][ TurfAttacker ]) {
                                      new msg1[ 256 ];
	                                  format(msg1,sizeof(msg1), "~w~We have provoked a turfwar ~w~in ~y~%s ( %s ) ~w~against the ~r~%s",
									  turfs[ i ][ turfName ], turfs[ i ][ cityName ], TeamInfo[ turfs[ i ][ TurfOwner ] ][ TeamName ]);
                                      new Text:txt1 = TextDrawCreate( 139.0, 350.0, msg1 );
                                      TextDrawFont( txt1, 1 );
                                      TextDrawLetterSize( txt1, 0.29, 1.0);
                                      TextDrawSetShadow( txt1, 0 );
                                      TextDrawSetOutline( txt1, 1 );
                                      TextDrawColor( txt1, 0xDFDFDFFF );
                                      TimeTextForPlayer( b, txt1, 6000 );
                                      GangZoneFlashForPlayer( b, turfs[ i ][turfID], COLOR_FLASH );
                                }
                                else if (gTeam[b] == turfs[ i ][ TurfOwner ]) {
                                      new msg2[ 256 ];
	                                  format(msg2,sizeof(msg2), "~r~The ~y~%s ~r~have attacked our turf in ~y~%s ( %s )!",
	                                  TeamInfo[ turfs[ i ][ TurfAttacker ] ][ TeamName ], turfs[ i ][ turfName ], turfs[ i ][ cityName ]);
                                      new Text:txt2 = TextDrawCreate( 139.0, 364.0, msg2 );
                                      TextDrawFont( txt2, 1 );
                                      TextDrawLetterSize( txt2, 0.29, 1.0);
                                      TextDrawSetShadow( txt2, 0 );
                                      TextDrawSetOutline( txt2, 1 );
                                      TextDrawColor( txt2, COLOR_RED );
                                      TimeTextForPlayer( b, txt2, 6000 );
                                      GangZoneFlashForPlayer( b, turfs[ i ][turfID], COLOR_FLASH );
                                }
                                else GangZoneFlashForPlayer( b, turfs[ i ][turfID], COLOR_FLASH2 );
	                       }
	                       SetTimerEx("EndWar", ATTACK_TIME, false ,"iii", i, turfs[ i ][ TurfAttacker ], turfs[ i ][ TurfOwner ] );
	                       turfs[ i ][ TurfWarStarted ] =1;
	                       for(new c=0; c<MAX_TEAMS; c++) { TurfInfo[ i ][ c ][ TurfKills ] =0; TurfInfo[ i ][ c ][ TurfAttackKills ] =0; }
                           return 1;
                       }
                   }
                   else if (turfs[ i ][ TurfWarStarted ] == 1 && !IsPlayerInAnyVehicle(killerid) &&
                           (turfs[ i ][ TurfAttacker ] == gTeam[killerid]) || turfs[ i ][ TurfOwner ] == gTeam[killerid])
                   {
                       TurfInfo[ i ][ gTeam[killerid] ][ TurfAttackKills ]++;
                       return 1;
                   }
	           }
	      }
//------------------------ Was there a bounty on players head -------------------
          if (bounty[ playerid ] > 0) {
		      GetPlayerName( playerid, killedplayer, sizeof( killedplayer ) );
		      format(string, sizeof(string), "* Bounty reward: %d for killing %s.", bounty[playerid], killedplayer);
		      SendClientMessage( killerid, COLOR_YELLOW, string );

              GivePlayerMoney( killerid, bounty[ playerid ] );
		      bounty[ playerid ] = 0;
          }
//------------------------ Did player had a wanted level -----------------------
          if (GetPlayerWantedLevel( playerid ) > 0) {
              switch( GetPlayerWantedLevel( playerid ) ) {
                      case 1: {
                           SendClientMessage( killerid, COLOR_YELLOW, "* Bonus for killing a player with a wanted level: $1000 + 1 point." );
                           GivePlayerMoney( killerid, 1000 );
                           SetPlayerScore( killerid, GetPlayerScore( killerid ) +1 );
                           SetPlayerWantedLevel( playerid, 0 );
                      }
                      case 2: {
                           SendClientMessage( killerid, COLOR_YELLOW, "* Bonus for killing a player with a wanted level: $2000 + 2 points." );
                           GivePlayerMoney( killerid, 2000);
                           SetPlayerScore( killerid, GetPlayerScore( killerid ) +2 );
                           SetPlayerWantedLevel( playerid, 0 );
                      }
                      case 3: {
                           SendClientMessage( killerid, COLOR_YELLOW, "* Bonus for killing a player with a wanted level: $3000 + 3 points." );
                           GivePlayerMoney( killerid, 3000 );
                           SetPlayerScore( killerid, GetPlayerScore( killerid ) +3 );
                           SetPlayerWantedLevel( playerid, 0 );
                      }
                      case 4: {
                           SendClientMessage( killerid, COLOR_YELLOW, "* Bonus for killing a player with a wanted level: $4000 + 4 points." );
                           GivePlayerMoney( killerid, 4000 );
                           SetPlayerScore( killerid, GetPlayerScore( killerid ) +4 );
                           SetPlayerWantedLevel( playerid, 0 );
                      }
                      case 5: {
                           SendClientMessage( killerid, COLOR_YELLOW, "* Bonus for killing a player with a wanted level: $5000 + 5 points." );
                           GivePlayerMoney( killerid, 5000 );
                           SetPlayerScore( killerid, GetPlayerScore( killerid ) +5 );
                           SetPlayerWantedLevel( playerid, 0 );
                      }
                      case 6..200: {
                           SendClientMessage( killerid, COLOR_YELLOW, "* Bonus for killing a player with a wanted level: $6000 + 6 points." );
                           GivePlayerMoney( killerid, 6000 );
                           SetPlayerScore( killerid, GetPlayerScore( killerid ) +6 );
                           SetPlayerWantedLevel( playerid, 0 );
                      }
              }
   	      }
//------------------------------------------------------------------------------
        }
        else //Team Killer!
	    {
		    new warning[ 256 ];
		    format( warning, sizeof( warning ), "* Be careful! No teamkilling." );
		    SendClientMessage( killerid, COLOR_RED, warning );
		    TeamKills[ killerid ]++;
		    if (TeamKills[ killerid ] == 3)
		    {
                SetPlayerInterior( killerid, 6 );
                SetPlayerPos( killerid, 264.6296, 77.1372, 1001.0390);
                ResetPlayerWeapons( killerid );
                GivePlayerMoney( killerid, -2500 );
		        SetPlayerScore( killerid, GetPlayerScore( killerid ) -5 );
		        SendClientMessage( killerid, COLOR_RED, "*** You've been jailed for teamkilling!" );
		        TeamKills[ killerid ] = 0;
		    }
        }
   	}

	return 1;
}
//==============================================================================

public CheckPlayers( )
{
    new Float:x, Float:y, Float:z;
    for (new i = 0; i < MAX_TURFS; i++)
	{
         for (new c = 0; c < MAX_TEAMS; c++) TurfInfo[ i ][ c ][ MIT ]=0;

         for (new b=0; b<SLOTS; b++) {
              if (Spawned[b] == 1 && !GetPlayerInterior(b))
			  {
                  GetPlayerPos(b, x, y, z);
			      if (IsPlayerInTurf(b, turfs[i][zMinX], turfs[i][zMinY], turfs[i][zMaxX], turfs[i][zMaxY]))
			      {
			          if (turfs[ i ][ TurfWarStarted ] != 1 && gTeam[b] != turfs[i][TurfOwner])
                      {
                           TurfInfo[ i ][ gTeam[b] ][ MIT ]++;
                           if (TurfInfo[ i ][ gTeam[b] ][ MIT ] >= MEMBERS_NEEDED)
                           {
                               if (TimerStarted[i] != 1) {
                                   TimerStarted[i] = 1;
                                   SetTimerEx("StartWar", STANDINTURF_TIME, 0, "ii", i, gTeam[b]);
                               }
                           }
                      }
			      }
			  }
	     }
	}
}
//==============================================================================

public StartWar( turf, attacker )
{
    new Float:x, Float:y, Float:z;

    TimerStarted[turf] = 0;
    for (new c=0; c<MAX_TEAMS; c++) {
	     TurfInfo[ turf ][ c ][ TurfKills ] =0;
	     TurfInfo[ turf ][ c ][ TurfAttackKills ] =0;
	     TurfInfo[ turf ][ c ][ MIT ]=0;
	}

    for (new id=0; id<SLOTS; id++)
	{
         if (Spawned[id] == 1 && !GetPlayerInterior(id))
         {
             GetPlayerPos(id, x, y, z);
             if (IsPlayerInTurf(id, turfs[turf][zMinX], turfs[turf][zMinY], turfs[turf][zMaxX], turfs[turf][zMaxY]))
	         {
                 if (turfs[ turf ][ TurfWarStarted ] != 1)
                 {
			         if (gTeam[id] == attacker)
			         {
                         TurfInfo[ turf ][ attacker ][ MIT ]++;
                         if (TurfInfo[ turf ][ attacker ][ MIT ] >= MEMBERS_NEEDED)
                         {
                             turfs[ turf ][ TurfAttacker ] = attacker;
                             for (new t=0; t<SLOTS; t++)
                             {
                                  if (gTeam[ t ] == turfs[ turf ][ TurfAttacker ]) {
                                      new msg1[ 256 ];
                                      format(msg1,sizeof(msg1), "~w~We have provoked a turf war ~w~in ~y~%s ( %s ) ~w~against the ~r~%s.",
									  turfs[ turf ][ turfName ], turfs[ turf ][ cityName ], TeamInfo[ turfs[ turf ][ TurfOwner ] ][ TeamName ]);
                                      new Text:txt1 = TextDrawCreate( 139.0, 350.0, msg1 );
                                      TextDrawFont( txt1, 1 );
                                      TextDrawLetterSize( txt1, 0.29, 1.0);
                                      TextDrawColor( txt1, 0xDFDFDFFF );
                                      TextDrawSetOutline( txt1, 1 );
                                      TextDrawSetShadow( txt1, 0 );
                                      TimeTextForPlayer( t, txt1, 6000 );
                                      GangZoneFlashForPlayer( t, turfs[ turf ][turfID], COLOR_FLASH );
                                  }
                                  else if (gTeam[t] == turfs[ turf ][ TurfOwner ]) {
                                      new msg2[ 256 ];
                                      format(msg2,sizeof(msg2), "~r~The ~y~%s ~r~have attacked our turf in ~y~%s ( %s )!",
	                                  TeamInfo[ turfs[ turf ][ TurfAttacker ] ][ TeamName ], turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
                                      new Text:txt2 = TextDrawCreate( 139.0, 364.0, msg2 );
                                      TextDrawFont( txt2, 1 );
                                      TextDrawLetterSize( txt2, 0.29, 1.0);
                                      TextDrawColor( txt2, COLOR_RED );
                                      TextDrawSetOutline( txt2, 1 );
                                      TextDrawSetShadow( txt2, 0 );
                                      TimeTextForPlayer( t, txt2, 6000 );
                                      GangZoneFlashForPlayer( t, turfs[ turf ][turfID], COLOR_FLASH );
                                  }
                                  else GangZoneFlashForPlayer( t, turfs[ turf ][turfID], COLOR_FLASH2 );
                             }
                             turfs[ turf ][ TurfWarStarted ] =1;
                             SetTimerEx("EndWar", ATTACK_TIME, false ,"iii", turf, turfs[ turf ][ TurfAttacker ], turfs[ turf ][ TurfOwner ] );
				         }
                     }
                 }
	         }
	     }
	}
}
//==============================================================================

public EndWar( turf, attacker, defender )
{
    new string[ 256 ];
    new Float:x, Float:y, Float:z;
	if (turfs[ turf ][ TurfWarStarted ] == 1)
	{
        GangZoneStopFlashForAll( turf );
        turfs[ turf ][ TurfWarStarted ] =0;

        // when attackers have more kills
        if (TurfInfo[ turf ][ attacker ][ TurfAttackKills ] > TurfInfo[ turf ][ defender ][ TurfAttackKills ])
        {
            for (new a=0; a<SLOTS; a++)
	        {
                 if (gTeam[ a ] == defender) { // send the message to losers
                     new msg1[ 256 ];
	                 format(msg1,sizeof(msg1), "~r~The ~y~%s ~r~have taken over our turf in ~y~%s ( %s )!",
	                 TeamInfo[ attacker ][ TeamName ], turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
                     new Text:txt1 = TextDrawCreate(139.0, 420.0, msg1);
                     TextDrawFont( txt1, 1 );
                     TextDrawLetterSize( txt1, 0.29, 1.0);
                     TextDrawSetShadow( txt1, 0 );
                     TextDrawSetOutline( txt1, 1 );
                     TextDrawColor( txt1, COLOR_RED );
                     TimeTextForPlayer( a, txt1, 6000 );
                     // send message with final score
                     format (string, sizeof(string), "Final score from the turf war in %s ( %s ). %s %d - %s %d.",
					 turfs[ turf ][ turfName ], turfs[ turf ][ cityName ],
					 TeamInfo[ attacker ][ TeamName ], TurfInfo[ turf ][ attacker ][ TurfAttackKills ],
					 TeamInfo[ defender ][ TeamName ], TurfInfo[ turf ][ defender ][ TurfAttackKills ]);
	                 SendClientMessage(a, TeamInfo[ defender ][ TeamColor ], string);
	                 TeamInfo[ defender ][ TurfWarsLost ]++;
	                 TeamInfo[ defender ][ TeamScore ]--;
		          }
	              else if (gTeam[ a ] == attacker) { // send the message to winners
                     new msg2[ 256 ];
                     format(msg2,sizeof(msg2), "~g~We won the turf war against the ~y~%s ~g~in ~y~%s ( %s )!",
			         TeamInfo[ defender ][ TeamName ], turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
			         new Text:txt2 = TextDrawCreate(139.0, 378.0, msg2);
                     TextDrawFont( txt2, 1 );
                     TextDrawLetterSize( txt2, 0.29, 1.0);
                     TextDrawSetShadow( txt2, 0 );
                     TextDrawSetOutline( txt2, 1 );
                     TextDrawColor( txt2, COLOR_GREEN );
                     TimeTextForPlayer( a, txt2, 6000 );
                     // send message with final score
                     format (string, sizeof(string), "Final score from the turf war in %s ( %s ). %s %d - %s %d.",
					 turfs[ turf ][ turfName ], turfs[ turf ][ cityName ],
					 TeamInfo[ attacker ][ TeamName ], TurfInfo[ turf ][ attacker ][ TurfAttackKills ],
					 TeamInfo[ defender ][ TeamName ], TurfInfo[ turf ][ defender ][ TurfAttackKills ]);
	                 SendClientMessage(a, TeamInfo[ defender ][ TeamColor ], string);
	                 TeamInfo[ attacker ][ TurfWarsWon ]++;
	                 TeamInfo[ attacker ][ TeamScore ]++;

                     // give winners prize
                     if ((attacker == TEAM_AZTECA || attacker == TEAM_VAGOS || attacker == TEAM_BALLA ||
					      attacker == TEAM_GROVE || attacker == TEAM_HOODLUM ))
                     {
                          if (turfs[ turf ][ turfID ] > 35 ) {
                              SendClientMessage( a, COLOR_GREEN, "Excellent! You took over a turf in a other city, you received $2500 + 3 points.");
                              GivePlayerMoney( a, 2500 );
                              SetPlayerScore( a, GetPlayerScore(a)+3 );
					      } else {
                              SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                              GivePlayerMoney( a, 1000 );
                              SetPlayerScore( a, GetPlayerScore(a)+1 );
					      }
					 }
					 else if ((attacker == TEAM_RIFA || attacker == TEAM_TRIAD || attacker == TEAM_NANG ||
					           attacker == TEAM_WORKER || attacker == TEAM_COP ))
                     {
                          if (turfs[ turf ][ turfID ] < 69 ) {
                              SendClientMessage( a, COLOR_GREEN, "Excellent! You took over a turf in a other city, you received $2500 + 3 points.");
                              GivePlayerMoney( a, 2500 );
                              SetPlayerScore( a, GetPlayerScore(a)+3 );
					      } else {
                              SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                              GivePlayerMoney( a, 1000 );
                              SetPlayerScore( a, GetPlayerScore(a)+1 );
					      }
					 }
					 else {
                          if ((turfs[ turf ][ turfID ] < 36 || turfs[ turf ][ turfID ] > 68 )) {
                              SendClientMessage( a, COLOR_GREEN, "Excellent! You took over a turf in a other city, you received $2500 + 3 points.");
                              GivePlayerMoney( a, 2500 );
                              SetPlayerScore( a, GetPlayerScore(a)+3 );
					      } else {
                              SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                              GivePlayerMoney( a, 1000 );
                              SetPlayerScore( a, GetPlayerScore(a)+1 );
					      }
					 }
					 // if teamscore >= TEAMSCORE give them all the turfs the defenders owns.
                     if (TeamInfo[ attacker ][ TeamScore ] >= TEAMSCORE) {
                         for (new i = 0; i < MAX_TURFS; i++) {
			   	         	  if (turfs[ i ][ TurfOwner ] == defender) {
								  if (turfs[ i ][ TurfWarStarted ] != 1) {
                                      turfs[ i ][ TurfOwner ] = attacker;
	                                  turfs[ i ][ TurfColor ] = TeamInfo[ attacker ][ TeamColor ];
	                                  GangZoneShowForAll( i, turfs[ i ][ TurfColor ] );
	                                  new msg[ 256 ];
                                      format(msg,sizeof(msg), "Excellent! Because of our teamscore: %d.~n~All their turfs belongs to us now.",
			                          TeamInfo[ attacker ][ TeamScore ]);
	                                  new Text:txt = TextDrawCreate( 23.0, 125.0, msg );
                                      TextDrawUseBox( txt, 1 );
	                                  TextDrawBoxColor( txt, 0x00000066 );
	                                  TextDrawTextSize( txt, 248.0, 0.0 );
	                                  TextDrawAlignment( txt, 0 );
	                                  TextDrawBackgroundColor( txt, 0x000000ff );
	                                  TextDrawFont( txt, 1 );
	                                  TextDrawLetterSize( txt, 0.29, 1.0 );
	                                  TextDrawColor( txt, 0xffffffff );
	                                  TextDrawSetOutline( txt, 1 );
	                                  TextDrawSetProportional( txt, 1 );
	                                  TimeTextForPlayer(a, txt, 6000);
	                              }
			         		  }
                         }
                     }
                 }
	        }
	        // change the zone colour and reset the counters
	        turfs[ turf ][ TurfOwner ] = attacker;
	        turfs[ turf ][ TurfColor ] = TeamInfo[ attacker ][ TeamColor ];
            GangZoneShowForAll( turf, turfs[ turf ][ TurfColor ] );
            turfs[ turf ][ TurfAttacker ] = -1;
            for (new c=0; c<MAX_TEAMS; c++) { TurfInfo[ turf ][ c ][ TurfKills ] =0; TurfInfo[ turf ][ c ][ TurfAttackKills ] =0; }
        }
        // when there are no kills in the turf
        else if (TurfInfo[ turf ][ attacker ][ TurfAttackKills ] == 0 && TurfInfo[ turf ][ defender ][ TurfAttackKills ] == 0)
        {
            for (new id=0; id<SLOTS; id++) {
                 if (Spawned[id] == 1 && !GetPlayerInterior(id))  {
                     GetPlayerPos(id, x, y, z);
                     if (IsPlayerInTurf(id, turfs[turf][zMinX], turfs[turf][zMinY], turfs[turf][zMaxX], turfs[turf][zMaxY])) {
                         if (gTeam[id] == attacker) TurfInfo[ turf ][ attacker ][ MIT ]++;
                         if (gTeam[id] == defender) TurfInfo[ turf ][ defender ][ MIT ]++;
				     }
				 }
	        }
            if (TurfInfo[ turf ][ attacker ][ MIT ] > TurfInfo[ turf ][ defender ][ MIT ])
            {
                for (new a=0; a<SLOTS; a++)
	            {
                     if (gTeam[ a ] == defender) { // send the message to losers
                         new msg1[ 256 ];
	                     format(msg1,sizeof(msg1), "~r~The ~y~%s ~r~have taken over our turf in ~y~%s ( %s )!",
	                     TeamInfo[ attacker ][ TeamName ], turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
                         new Text:txt1 = TextDrawCreate(139.0, 420.0, msg1);
                         TextDrawFont( txt1, 1 );
                         TextDrawLetterSize( txt1, 0.29, 1.0);
                         TextDrawSetShadow( txt1, 0 );
                         TextDrawSetOutline( txt1, 1 );
                         TextDrawColor( txt1, COLOR_RED );
                         TimeTextForPlayer( a, txt1, 6000 );
                         // send message
                         format (string, sizeof(string), "They beated us with their overwhelming presence. They had %d members on our turf.",
					     TurfInfo[ turf ][ attacker ][ MIT ]);
	                     SendClientMessage(a, TeamInfo[ defender ][ TeamColor ], string);
	                     TeamInfo[ defender ][ TurfWarsLost ]++;
	                     TeamInfo[ defender ][ TeamScore ]--;
		             }
	                 else if (gTeam[ a ] == attacker) { // send the message to winners
                         new msg2[ 256 ];
                         format(msg2,sizeof(msg2), "~g~We won the turf war against the ~y~%s ~g~in ~y~%s ( %s )!",
			             TeamInfo[ defender ][ TeamName ], turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
			             new Text:txt2 = TextDrawCreate(139.0, 378.0, msg2);
                         TextDrawFont( txt2, 1 );
                         TextDrawLetterSize( txt2, 0.29, 1.0);
                         TextDrawSetShadow( txt2, 0 );
                         TextDrawSetOutline( txt2, 1 );
                         TextDrawColor( txt2, COLOR_GREEN );
                         TimeTextForPlayer( a, txt2, 6000 );
                         // send message
                         format (string, sizeof(string), "We beated them with our overwhelming presence. We had %d members on their turf.",
					     TurfInfo[ turf ][ attacker ][ MIT ]);
	                     SendClientMessage(a, TeamInfo[ attacker ][ TeamColor ], string);
	                     TeamInfo[ attacker ][ TurfWarsWon ]++;
	                     TeamInfo[ attacker ][ TeamScore ]++;

                         // give winners prize
                         if ((attacker == TEAM_AZTECA || attacker == TEAM_VAGOS || attacker == TEAM_BALLA ||
					          attacker == TEAM_GROVE || attacker == TEAM_HOODLUM ))
                         {
                              if (turfs[ turf ][ turfID ] > 35 ) {
                                  SendClientMessage( a, COLOR_GREEN, "Excellent! You took over a turf in a other city, you received $2500 + 3 points.");
                                  GivePlayerMoney( a, 2500 );
                                  SetPlayerScore( a, GetPlayerScore(a)+3 );
					          } else {
                                  SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                                  GivePlayerMoney( a, 1000 );
                                  SetPlayerScore( a, GetPlayerScore(a)+1 );
				    	      }
				    	 }
				    	 else if ((attacker == TEAM_RIFA || attacker == TEAM_TRIAD || attacker == TEAM_NANG ||
				    	           attacker == TEAM_WORKER || attacker == TEAM_COP ))
                         {
                              if (turfs[ turf ][ turfID ] < 69 ) {
                                  SendClientMessage( a, COLOR_GREEN, "Excellent! You took over a turf in a other city, you received $2500 + 3 points.");
                                  GivePlayerMoney( a, 2500 );
                                  SetPlayerScore( a, GetPlayerScore(a)+3 );
				    	      } else {
                                  SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                                  GivePlayerMoney( a, 1000 );
                                  SetPlayerScore( a, GetPlayerScore(a)+1 );
			    		      }
			    		 }
			    		 else {
                              if ((turfs[ turf ][ turfID ] < 36 || turfs[ turf ][ turfID ] > 68 )) {
                                  SendClientMessage( a, COLOR_GREEN, "Excellent! You took over a turf in a other city, you received $2500 + 3 points.");
                                  GivePlayerMoney( a, 2500 );
                                  SetPlayerScore( a, GetPlayerScore(a)+3 );
			      		      } else {
                                  SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                                  GivePlayerMoney( a, 1000 );
                                  SetPlayerScore( a, GetPlayerScore(a)+1 );
			    		      }
			    		 }
                     }
	            }
	            // change the zone colour and reset the counters
	            turfs[ turf ][ TurfOwner ] = attacker;
	            turfs[ turf ][ TurfColor ] = TeamInfo[ attacker ][ TeamColor ];
                GangZoneShowForAll( turf, turfs[ turf ][ TurfColor ] );
                turfs[ turf ][ TurfAttacker ] = -1;
                for (new c=0; c<MAX_TEAMS; c++) { TurfInfo[ turf ][ c ][ TurfKills ] =0; TurfInfo[ turf ][ c ][ TurfAttackKills ] =0; }
            }
            else
            {
                for (new a=0; a<SLOTS; a++)
	            {
                     if (gTeam[ a ] == defender) { // send the message to winners
                         new msg3[ 256 ];
                         format(msg3,sizeof(msg3), "~g~That showed them. The turf in ~y~%s ( %s ) ~g~remain ours.",
					     turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
					     new Text:txt3 = TextDrawCreate( 139.0, 392.0, msg3);
                         TextDrawFont( txt3, 1 );
                         TextDrawLetterSize( txt3, 0.29, 1.0);
                         TextDrawSetShadow( txt3, 0 );
                         TextDrawSetOutline( txt3, 1 );
                         TextDrawColor( txt3, COLOR_GREEN );
                         TimeTextForPlayer( a, txt3, 6000 );
                         // send message
                         SendClientMessage( a, TeamInfo[ defender ][ TeamColor ], "Those fools thinking they can take over our turf.");
	                     TeamInfo[ defender ][ TurfWarsWon ]++;
	                     TeamInfo[ defender ][ TeamScore ]++;

				    	 // give winners prize
                         if ((defender == TEAM_AZTECA || defender == TEAM_VAGOS || defender == TEAM_BALLA ||
					          defender == TEAM_GROVE || defender == TEAM_HOODLUM ))
                         {
                              if (turfs[ turf ][ turfID ] > 35 ) {
                                  SendClientMessage( a, COLOR_GREEN, "Excellent! You defended a turf in a other city, you received $2500 + 3 points.");
                                  GivePlayerMoney( a, 2500 );
                                  SetPlayerScore( a, GetPlayerScore(a)+3 );
					          } else {
                                  SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                                  GivePlayerMoney( a, 1000 );
                                  SetPlayerScore( a, GetPlayerScore(a)+1 );
					          }
				    	 }
				    	 else if ((defender == TEAM_RIFA || defender == TEAM_TRIAD || defender == TEAM_NANG ||
				    	           defender == TEAM_WORKER || defender == TEAM_COP ))
                         {
                              if (turfs[ turf ][ turfID ] < 69 ) {
                                  SendClientMessage( a, COLOR_GREEN, "Excellent! You defended a turf in a other city, you received $2500 + 3 points.");
                                  GivePlayerMoney( a, 2500 );
                                  SetPlayerScore( a, GetPlayerScore(a)+3 );
					          } else {
                                  SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                                  GivePlayerMoney( a, 1000 );
                                  SetPlayerScore( a, GetPlayerScore(a)+1 );
					          }
					     }
					     else {
                              if ((turfs[ turf ][ turfID ] < 36 || turfs[ turf ][ turfID ] > 68 )) {
                                  SendClientMessage( a, COLOR_GREEN, "Excellent! You defended a turf in a other city, you received $2500 + 3 points.");
                                  GivePlayerMoney( a, 2500 );
                                  SetPlayerScore( a, GetPlayerScore(a)+3 );
					          } else {
                                  SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                                  GivePlayerMoney( a, 1000 );
                                  SetPlayerScore( a, GetPlayerScore(a)+1 );
					          }
				    	 }
		             }
		             else if (gTeam[ a ] == attacker) { // send the message to losers
                         new msg4[ 256 ];
	                     format(msg4,sizeof(msg4), "~r~We lost the turf war against the ~y~%s ~r~in ~y~%s ( %s )!",
					     TeamInfo[ defender ][ TeamName ], turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
                         new Text:txt4 = TextDrawCreate(139.0, 406.0, msg4);
                         TextDrawFont( txt4, 1 );
                         TextDrawLetterSize( txt4, 0.29, 1.0);
                         TextDrawSetShadow( txt4, 0 );
                         TextDrawSetOutline( txt4, 1 );
                         TextDrawColor( txt4, COLOR_RED );
                         TimeTextForPlayer( a, txt4, 6000 );
                         // send message
                         SendClientMessage( a, TeamInfo[ attacker ][ TeamColor ], "Pity, we were in the minority.");
	                     TeamInfo[ attacker ][ TurfWarsLost ]++;
	                     TeamInfo[ attacker ][ TeamScore ]--;
                     }
	            }
	            // change the zone colour and reset the counters
	            turfs[ turf ][ TurfOwner ] = defender;
	            turfs[ turf ][ TurfColor ] = TeamInfo[ defender ][ TeamColor ];
                GangZoneShowForAll( turf, turfs[ turf ][ TurfColor ] );
                turfs[ turf ][ TurfAttacker ] = -1;
                for (new c=0; c<MAX_TEAMS; c++) { TurfInfo[ turf ][ c ][ TurfKills ] =0; TurfInfo[ turf ][ c ][ TurfAttackKills ] =0; }
            }
        }
        // when it's a draw (not 0-0) or defenders have more kills
        else
		{
            for (new a=0; a<SLOTS; a++)
	        {
                 if (gTeam[ a ] == defender) { // send the message to winners
                     new msg3[ 256 ];
                     format(msg3,sizeof(msg3), "~g~That showed them. The turf in ~y~%s ( %s ) ~g~remain ours.",
					 turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
					 new Text:txt3 = TextDrawCreate(139.0, 392.0, msg3);
                     TextDrawFont( txt3, 1 );
                     TextDrawLetterSize( txt3, 0.29, 1.0);
                     TextDrawSetShadow( txt3, 0 );
                     TextDrawSetOutline( txt3, 1 );
                     TextDrawColor( txt3, COLOR_GREEN );
                     TimeTextForPlayer( a, txt3, 6000 );
                     // send message with final score
                     format (string, sizeof(string), "Final score from the turfwar in %s ( %s ). %s %d - %s %d.",
					 turfs[ turf ][ turfName ], turfs[ turf ][ cityName ],
					 TeamInfo[ defender ][ TeamName ], TurfInfo[ turf ][ defender ][ TurfAttackKills ],
					 TeamInfo[ attacker ][ TeamName ], TurfInfo[ turf ][ attacker ][ TurfAttackKills ]);
	                 SendClientMessage(a, TeamInfo[ defender ][ TeamColor ], string);
	                 TeamInfo[ defender ][ TurfWarsWon ]++;
	                 TeamInfo[ defender ][ TeamScore ]++;

					 // give winners prize
                     if ((defender == TEAM_AZTECA || defender == TEAM_VAGOS || defender == TEAM_BALLA ||
					      defender == TEAM_GROVE || defender == TEAM_HOODLUM ))
                     {
                          if (turfs[ turf ][ turfID ] > 35 ) {
                              SendClientMessage( a, COLOR_GREEN, "Excellent! You defended a turf in a other city, you received $2500 + 3 points.");
                              GivePlayerMoney( a, 2500 );
                              SetPlayerScore( a, GetPlayerScore(a)+3 );
					      } else {
                              SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                              GivePlayerMoney( a, 1000 );
                              SetPlayerScore( a, GetPlayerScore(a)+1 );
					      }
					 }
					 else if ((defender == TEAM_RIFA || defender == TEAM_TRIAD || defender == TEAM_NANG ||
					           defender == TEAM_WORKER || defender == TEAM_COP ))
                     {
                          if (turfs[ turf ][ turfID ] < 69 ) {
                              SendClientMessage( a, COLOR_GREEN, "Excellent! You defended a turf in a other city, you received $2500 + 3 points.");
                              GivePlayerMoney( a, 2500 );
                              SetPlayerScore( a, GetPlayerScore(a)+3 );
					      } else {
                              SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                              GivePlayerMoney( a, 1000 );
                              SetPlayerScore( a, GetPlayerScore(a)+1 );
					      }
					 }
					 else {
                          if ((turfs[ turf ][ turfID ] < 36 || turfs[ turf ][ turfID ] > 68 )) {
                              SendClientMessage( a, COLOR_GREEN, "Excellent! You defended a turf in a other city, you received $2500 + 3 points.");
                              GivePlayerMoney( a, 2500 );
                              SetPlayerScore( a, GetPlayerScore(a)+3 );
					      } else {
                              SendClientMessage( a, COLOR_GREEN, "Well done. You received $1000 + 1 point.");
                              GivePlayerMoney( a, 1000 );
                              SetPlayerScore( a, GetPlayerScore(a)+1 );
					      }
					 }
		         }
		         else if (gTeam[ a ] == attacker) { // send the message to losers
                     new msg4[ 256 ];
	                 format(msg4,sizeof(msg4), "~r~We lost the turfwar against the ~y~%s ~r~in ~y~%s ( %s )!",
					 TeamInfo[ defender ][ TeamName ], turfs[ turf ][ turfName ], turfs[ turf ][ cityName ]);
                     new Text:txt4 = TextDrawCreate(139.0, 406.0, msg4);
                     TextDrawFont( txt4, 1 );
                     TextDrawLetterSize( txt4, 0.29, 1.0);
                     TextDrawSetShadow( txt4, 0 );
                     TextDrawSetOutline( txt4, 1 );
                     TextDrawColor( txt4, COLOR_RED );
                     TimeTextForPlayer( a, txt4, 6000 );
                     // send message with final score
                     format (string, sizeof(string), "Final score from the turfwar in %s ( %s ). %s %d - %s %d.",
					 turfs[ turf ][ turfName ], turfs[ turf ][ cityName ],
					 TeamInfo[ defender ][ TeamName ], TurfInfo[ turf ][ defender ][ TurfAttackKills ],
					 TeamInfo[ attacker ][ TeamName ], TurfInfo[ turf ][ attacker ][ TurfAttackKills ]);
	                 SendClientMessage(a, TeamInfo[ defender ][ TeamColor ], string);
	                 TeamInfo[ attacker ][ TurfWarsLost ]++;
	                 TeamInfo[ attacker ][ TeamScore ]--;
                 }
	        }
	        // if teamscore >= TEAMSCORE reset the teamscore.
            if (TeamInfo[ attacker ][ TeamScore ] >= TEAMSCORE) TeamInfo[ attacker ][ TeamScore ] =0;
	        // change the zone colour and reset the counters
	        turfs[ turf ][ TurfOwner ] = defender;
	        turfs[ turf ][ TurfColor ] = TeamInfo[ defender ][ TeamColor ];
            GangZoneShowForAll( turf, turfs[ turf ][ TurfColor ] );
            turfs[ turf ][ TurfAttacker ] = -1;
            for (new c=0; c<MAX_TEAMS; c++) { TurfInfo[ turf ][ c ][ TurfKills ] =0; TurfInfo[ turf ][ c ][ TurfAttackKills ] =0; }
		}
	}
}
//==============================================================================

public OnPlayerSelectedMenuRow( playerid, row )
{
    new Menu:current;
    current = GetPlayerMenu( playerid );
    if (current == LSAMenu)
    {
        switch(row)
        {
            case 0: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LSAMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 1664.6570, 1474.9343, 10.7813);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Las Venturas." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 1: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LSAMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, -1383.6849, -342.6660, 14.1484);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to San Fierro." );
                 TogglePlayerControllable( playerid, 1 );
                 
            }
            case 2: {
                 HideMenuForPlayer( LSAMenu, playerid );
                 TogglePlayerControllable( playerid, 1 );
		    }
        }
    }
    else if (current == LVAMenu)
    {
        switch(row)
        {
            case 0: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LVAMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 1685.7311, -2333.6418, 13.5469);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Los Santos." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 1: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LVAMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, -1383.6849, -342.6660, 14.1484);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to San Fierro." );
                 TogglePlayerControllable( playerid, 1 );

            }
            case 2: {
                 HideMenuForPlayer( LVAMenu, playerid );
                 TogglePlayerControllable( playerid, 1 );
		    }
        }
    }
    else if (current == SFAMenu)
    {
        switch(row)
        {
            case 0: {
				 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( SFAMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 1685.7311, -2333.6418, 13.5469);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Los Santos." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 1: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( SFAMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 1664.6570, 1474.9343, 10.7813);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Las Venturas." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 2: {
                 HideMenuForPlayer( SFAMenu, playerid );
                 TogglePlayerControllable( playerid, 1 );
		    }
        }
    }
    else if (current == LSTMenu)
    {
        switch(row)
        {
            case 0: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LSTMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 2855.8418, 1290.4384, 11.3906);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Las Venturas." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 1: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LSTMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, -1959.4329, 138.2027, 27.6940);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to San Fierro." );
                 TogglePlayerControllable( playerid, 1 );

            }
            case 2: {
                 HideMenuForPlayer( LSTMenu, playerid );
                 TogglePlayerControllable( playerid, 1 );
		    }
        }
    }
    else if (current == LVTMenu)
    {
        switch(row)
        {
            case 0: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LVTMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 1742.8361, -1863.3177, 13.5752);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Los Santos." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 1: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( LVTMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, -1959.4329, 138.2027, 27.6940);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to San Fierro." );
                 TogglePlayerControllable( playerid, 1 );

            }
            case 2: {
                 HideMenuForPlayer( LVTMenu, playerid );
                 TogglePlayerControllable( playerid, 1 );
		    }
        }
    }
    else if (current == SFTMenu)
    {
        switch(row)
        {
            case 0: {
				 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( SFTMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 1742.8361, -1863.3177, 13.5752);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Los Santos." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 1: {
                 if (GetPlayerMoney(playerid) < 2500) {
				     SendClientMessage( playerid, COLOR_RED, "*** Not enough money to travel." );
				     TogglePlayerControllable( playerid, 1 );
				     return 1;
				 }
                 HideMenuForPlayer( SFTMenu, playerid );
                 SetPlayerInterior( playerid, 0 );
                 SetPlayerPos( playerid, 2855.8418, 1290.4384, 11.3906);
                 GivePlayerMoney( playerid, -2500);
                 SendClientMessage( playerid, COLOR_ORANGE, "*** Welcome to Las Venturas." );
                 TogglePlayerControllable( playerid, 1 );
            }
            case 2: {
                 HideMenuForPlayer( SFTMenu, playerid );
                 TogglePlayerControllable( playerid, 1 );
		    }
        }
    }
    return 1;
}
//==============================================================================

public OnPlayerExitedMenu( playerid )
{
    TogglePlayerControllable( playerid, 1 );
	return 1;
}
//==============================================================================

public OnPlayerCommandText( playerid, cmdtext[] )
{
    if (!IsPlayerConnected(playerid)) return 0; // Check for undisconnected bug.
    new
        i,
        c;
    while ((c = cmdtext[i++])) if (c < 0x20 || c > 0x7E) return 0; // Check for illegal characters.

    dcmd(kill, 4, cmdtext);
    dcmd(help, 4, cmdtext);
	dcmd(turfhelp, 8, cmdtext);
    dcmd(commands, 8, cmdtext);
    dcmd(rules, 5, cmdtext);
    dcmd(credits, 7, cmdtext);
    dcmd(report, 6, cmdtext);
    dcmd(me, 2, cmdtext);
	dcmd(hitman, 6, cmdtext);
	dcmd(bounties, 8, cmdtext);
	dcmd(buyweapon, 9, cmdtext);
	dcmd(list, 4, cmdtext);
	dcmd(list2, 5, cmdtext);
	dcmd(seepm, 5, cmdtext);
	dcmd(hidepm, 6, cmdtext);
	dcmd(seetpm, 6, cmdtext);
	dcmd(hidetpm, 7, cmdtext);
    dcmd(on, 2, cmdtext);
    dcmd(off, 3, cmdtext);
	dcmd(a, 1, cmdtext);
	dcmd(teamids, 7, cmdtext);
	dcmd(teamstats, 9, cmdtext);
	dcmd(sellpoints, 10, cmdtext);

    return 0;
}
//==============================================================================
dcmd_kill(playerid, cmdtext[]) {
    #pragma unused cmdtext
    SetPlayerHealth( playerid, 0 );
    return 1;
}
dcmd_help(playerid, cmdtext[]) {
    #pragma unused cmdtext
    SendClientMessage(playerid, COLOR_RED,"SATW Ultimate help");
    SendClientMessage(playerid, COLOR_YELLOW,"This is a Team Death Match gamemode where you can kill players to receive money and points.");
    SendClientMessage(playerid, COLOR_YELLOW,"You can take over turfs with your team. Type /turfhelp for info");
    SendClientMessage(playerid, COLOR_YELLOW,"You can purchase weapons in the ammunation that you will have every time you spawn.");
    SendClientMessage(playerid, COLOR_YELLOW,"Want to visit a other city? Go to the checkpoint at the airport or the trainstation.");
    SendClientMessage(playerid, COLOR_YELLOW,"Type /tpm <message> to talk in Team-Chat. And see your teams stats: /teamstats (teamid)");
    SendClientMessage(playerid, COLOR_YELLOW,"See a rulebreaker? Use /report <id> <reason>.");
    SendClientMessage(playerid, COLOR_YELLOW,"You can see the server rules under /rules.");
    SendClientMessage(playerid, COLOR_ORANGE,"Type /commands for a full list of commands.");
    return 1;
}
dcmd_turfhelp(playerid, cmdtext[]) {
    #pragma unused cmdtext
    SendClientMessage(playerid, COLOR_RED,"SATW Ultimate Turf help");
    SendClientMessage(playerid, COLOR_YELLOW,"There are 2 ways to provoke a turfwar. 1) Kill 5 players in a specific area.");
    SendClientMessage(playerid, COLOR_YELLOW,"2) Or get at least 10 members in a turf for a short amount of time.");
    SendClientMessage(playerid, COLOR_YELLOW,"The turf youve attacked, will flash with a red color on your radar.");
    SendClientMessage(playerid, COLOR_YELLOW,"If you see a turf flashing with a white color, it means the turf");
    SendClientMessage(playerid, COLOR_YELLOW,"is under attack, but not by your team.");
    SendClientMessage(playerid, COLOR_YELLOW,"After 3 minutes the team with the most kills in that area wins the turfwar.");
    SendClientMessage(playerid, COLOR_YELLOW,"Or when there are no kills in a turf the team with the most members on it wins!");
    SendClientMessage(playerid, COLOR_GREEN,"The winners will receive $1000 + 1 point.");
    SendClientMessage(playerid, COLOR_GREEN,"If the turfwar was in a other city the winners will receive $2500 + 3 points.");
    return 1;
}
dcmd_commands(playerid, cmdtext[]) {
    #pragma unused cmdtext
    SendClientMessage(playerid, COLOR_RED,"SATW Ultimate commands");
    SendClientMessage(playerid, COLOR_YELLOW,"/help | /turfhelp | /commands | /credits");
    SendClientMessage(playerid, COLOR_YELLOW,"/pm <playerid> <message> | /tpm <message>");
    SendClientMessage(playerid, COLOR_YELLOW,"/buyweapon <weaponid> <amount> | /list | /list2");
    SendClientMessage(playerid, COLOR_YELLOW,"/givecash <playerid> <amount> | /bounties | | /sellpoints <amount>");
    SendClientMessage(playerid, COLOR_YELLOW,"/hitman <playerid> <amount> | /teamstats (teamid) | /teamids");
    SendClientMessage(playerid, COLOR_YELLOW,"/report <playerid> <reason> | /me <message>");
    return 1;
}
dcmd_rules(playerid, cmdtext[]) {
    #pragma unused cmdtext
    SendClientMessage(playerid, COLOR_RED,"SATW Ultimate server rules");
    SendClientMessage(playerid, COLOR_YELLOW,"There are several rules which you need to follow to avoid a kick or a ban.");
    SendClientMessage(playerid, COLOR_YELLOW,"1. No cheating/hacking or spamming/flaming.");
    SendClientMessage(playerid, COLOR_YELLOW,"2. No bug abuse.");
    SendClientMessage(playerid, COLOR_YELLOW,"3. Obey the admins and show them some respect.");
    SendClientMessage(playerid, COLOR_YELLOW,"4. Don't annoy the admins.");
    SendClientMessage(playerid, COLOR_YELLOW,"5. Don't abuse or spam, /me and /report commands.");
    SendClientMessage(playerid, COLOR_YELLOW,"6. Don't camp exit doors continuously.");
    SendClientMessage(playerid, COLOR_YELLOW,"7. Don't fight in ammunation and food places.");
    SendClientMessage(playerid, COLOR_YELLOW,"8. No racism.");
    return 1;
}
dcmd_credits(playerid, cmdtext[]) {
    #pragma unused cmdtext
    SendClientMessage(playerid, COLOR_RED,"SATW Ultimate credits");
    SendClientMessage(playerid, COLOR_YELLOW,"Gamemode by: Popo");
    SendClientMessage(playerid, COLOR_YELLOW,"Credits to: [W]Hustler, Simon, Mike,");
    SendClientMessage(playerid, COLOR_YELLOW,"Jax, Sintax, -Seif-, Lethal, [NB]90NINE,");
    SendClientMessage(playerid, COLOR_YELLOW,"HAMM3R and LeD.");
    SendClientMessage(playerid, COLOR_YELLOW,"And all the people i forgot.");
    return 1;
}
dcmd_report(playerid, text[]) {
    if(strlen(text) > 0) {
	    new string[256], playername[MAX_PLAYER_NAME];
	    GetPlayerName(playerid, playername, sizeof(playername));
        format(string, sizeof(string), "Report from %s(%d): %s", playername, playerid, text[0]);
        SendAdminMessage(COLOR_RED, string);
        format(string, sizeof(string), "Report sent to currently online admins.");
        SendClientMessage(playerid, COLOR_ORANGE, string);
    }
    else {
         new string[256];
		 format(string, sizeof(string), "Usage: /report [id] [reason]");
         SendClientMessage(playerid, COLOR_WHITE, string);
    }
    return 1;
}
dcmd_me(const playerid, message[])
{
    if (!strlen(message)) {
        SendClientMessage(playerid,COLOR_RED,"USAGE : /me [message]");
    }
    else {
        new pname[ MAX_PLAYER_NAME ], string[ 256 ];
        GetPlayerName( playerid, pname, sizeof( pname ));
        format( string, 256, "%s %s", pname, message );
        SendClientMessageToAll( COLOR_ME, string );
    }
    return 1;
}
dcmd_hitman(playerid, cmdtext[])
{
        #pragma unused cmdtext
        new string[256];
        new sendername[MAX_PLAYER_NAME];
        new giveplayer[MAX_PLAYER_NAME];
        new giveplayerid, moneys, idx;
        new tmp[256];
		tmp = strtok(cmdtext, idx);

		if(!strlen(tmp)) {
			SendClientMessage(playerid, COLOR_WHITE, "USAGE: /hitman [playerid] [amount]");
			return 1;
		}
		giveplayerid = strval(tmp);

		tmp = strtok(cmdtext, idx);
		if(!strlen(tmp)) {
			SendClientMessage(playerid, COLOR_WHITE, "USAGE: /hitman [playerid] [amount]");
			return 1;
		}
 		moneys = strval(tmp);

	    if(moneys > AC_GetPlayerMoney(playerid)) {
			SendClientMessage(playerid, COLOR_RED, "You don't have enough money!");
			return 1;
	    }
	    if(moneys < 100) {
			SendClientMessage(playerid, COLOR_RED, "A bounty must be $100 at least!");
			return 1;
		}
		if(bounty[giveplayerid] == 100000) {
			SendClientMessage(playerid, COLOR_RED, "A bounty can't be more than $100000!");
			return 1;
		}
		if(IsPlayerConnected(giveplayerid)==0) {
			SendClientMessage(playerid, COLOR_RED, "No such player exists.");
			return 1;
		}

		bounty[giveplayerid]+=moneys;
		GivePlayerMoney(playerid, 0-moneys);

		GetPlayerName(giveplayerid, giveplayer, sizeof(giveplayer));
		GetPlayerName(playerid, sendername, sizeof(sendername));

		format(string, sizeof(string), "%s has had a $%d bounty put on his head from %s (total: $%d).", giveplayer, moneys, sendername, bounty[giveplayerid]);
		SendClientMessageToAll(COLOR_ORANGE, string);

		format(string, sizeof(string), "You have had a $%d bounty put on you from %s (id: %d).", moneys, sendername, playerid);
		SendClientMessage(giveplayerid, COLOR_RED, string);
        return 1;
}
dcmd_bounties(playerid, cmdtext[])
{
        #pragma unused cmdtext
        new string[256];
        new giveplayer[MAX_PLAYER_NAME];
//      new tmp[256];
		new x;
		SendClientMessage(playerid, COLOR_GREEN, "Current Bounties:");
	    for(new i=0; i < SLOTS; i++) {
			if(IsPlayerConnected(i) && bounty[i] > 0) {
				GetPlayerName(i, giveplayer, sizeof(giveplayer));
				format(string, sizeof(string), "%s%s(%d): $%d", string,giveplayer,i,bounty[i]);

				x++;
				if(x > 3) {
				    SendClientMessage(playerid, COLOR_YELLOW, string);
				    x = 0;
					format(string, sizeof(string), "");
				} else {
					format(string, sizeof(string), "%s, ", string);
				}
			}
		}
		if(x <= 3 && x > 0) {
			string[strlen(string)-2] = '.';
		    SendClientMessage(playerid, COLOR_YELLOW, string);
		}
        return 1;
}
dcmd_buyweapon(playerid, cmdtext[]) {
    #pragma unused cmdtext
    new string[256];
    new idx, weaponid;
    new tmp[256], tmp2[256];
	tmp = strtok(cmdtext, idx);
	tmp2 = strtok(cmdtext, idx);

	if(!strlen(tmp) || !strlen(tmp2)) {
		SendClientMessage(playerid, COLOR_WHITE, "USAGE: /buyweapon [weapon_number] [amount]");
		return 1;
	}
	weaponid = strval(tmp);
	new ammos = strval(tmp2);

	if(IsPlayerInCheckpoint(playerid)==0 || playerCheckpoint[playerid]!=CP_AMMU && playerCheckpoint[playerid]!=CP_AMMU_2) {
		SendClientMessage(playerid, COLOR_YELLOW, "You need to be in an Ammunation to buy weapons.");
		return 1;
	}
	if(AC_GetPlayerMoney(playerid) < weaponCost[weaponid]*ammos) {
		SendClientMessage(playerid, COLOR_RED, "You don't have enough money!");
		return 1;
	}
	if(weaponid < 0 || weaponid > MAX_WEAPONS-1){
		SendClientMessage(playerid, COLOR_RED, "Invalid weapon number.");
		return 1;
	}
	if(ammos < 1) {
		SendClientMessage(playerid, COLOR_RED, "Invalid weapon amount.");
		return 1;
	}

	format (string, sizeof(string), "You bought %d %s's for when you spawn.",ammos,weaponNames[weaponid]);
	SendClientMessage(playerid, COLOR_GREEN, string);

	GivePlayerWeapon(playerid, weaponIDs[weaponid], weaponAmmo[weaponid]*ammos);
	playerWeapons[playerid][weaponid] += ammos;

	GivePlayerMoney(playerid, 0-(weaponCost[weaponid]*ammos));
    return 1;
}
dcmd_list(playerid, cmdtext[]) {
    #pragma unused cmdtext
    new string[256];
    new weaponstemp = MAX_WEAPONS;
    if(IsPlayerInCheckpoint(playerid)==0 || playerCheckpoint[playerid]!=CP_AMMU && playerCheckpoint[playerid]!=CP_AMMU_2) {
		SendClientMessage(playerid, COLOR_YELLOW, "You need to be in an ammunation checkpoint.");
		return 1;
	}
	if(weaponstemp>8) {
		weaponstemp = 8;
	}
	SendClientMessage(playerid, COLOR_GREEN, "Weapon List 1/2:");
	for(new i = 0; i < weaponstemp; i++) {
		format (string, sizeof(string), "%d. %s - $%d",i,weaponNames[i],weaponCost[i]);
		SendClientMessage(playerid, COLOR_YELLOW, string);
	}
    return 1;
}
dcmd_list2(playerid, cmdtext[]) {
    #pragma unused cmdtext
    new string[256];
    if(IsPlayerInCheckpoint(playerid)==0 || playerCheckpoint[playerid]!=CP_AMMU && playerCheckpoint[playerid]!=CP_AMMU_2) {
		SendClientMessage(playerid, COLOR_YELLOW, "You need to be in an ammunation checkpoint.");
		return 1;
	}
    SendClientMessage(playerid, COLOR_GREEN, "Weapon List 2/2:");
	for(new i = 8; i < MAX_WEAPONS; i++) {
        format (string, sizeof(string), "%d. %s - $%d",i,weaponNames[i],weaponCost[i]);
		SendClientMessage(playerid, COLOR_YELLOW, string);
	}
    return 1;
}
dcmd_seepm(playerid, cmdtext[]) {
    #pragma unused cmdtext
    if (!IsPlayerAdmin(playerid)) SendClientMessage(playerid, COLOR_RED, "You're not an admin.");
	else {
        ShowPM[playerid]= 1;
        SendClientMessage(playerid, COLOR_GREEN, "You can see PM's now.");
	}
    return 1;
}
dcmd_hidepm(playerid, cmdtext[]) {
    #pragma unused cmdtext
    if (!IsPlayerAdmin(playerid)) SendClientMessage(playerid, COLOR_RED, "You're not an admin.");
    else {
        ShowPM[playerid]= 0;
        SendClientMessage(playerid, COLOR_RED, "You can't see PM's anymore.");
	}
    return 1;
}
dcmd_seetpm(playerid, cmdtext[]) {
    #pragma unused cmdtext
    if (!IsPlayerAdmin(playerid)) SendClientMessage(playerid, COLOR_RED, "You're not an admin.");
    else {
        ShowTPM[playerid]= 1;
        SendClientMessage(playerid, COLOR_GREEN, "You can see TPM's now.");
	}
    return 1;
}
dcmd_hidetpm(playerid, cmdtext[]) {
    #pragma unused cmdtext
    if (!IsPlayerAdmin(playerid)) SendClientMessage(playerid, COLOR_RED, "You're not an admin.");
    else {
        ShowTPM[playerid]= 0;
        SendClientMessage(playerid, COLOR_RED, "You can't see TPM's anymore.");
	}
    return 1;
}
dcmd_on(playerid, cmdtext[]) {
    #pragma unused cmdtext
    if (!IsPlayerAdmin(playerid)) SendClientMessage(playerid, COLOR_RED, "You're not an admin.");
	else {
        SetPlayerColor(playerid, COLOR_WHITE);
        PlayerOnDuty[playerid] =1;
	}
    return 1;
}
dcmd_off(playerid, cmdtext[]) {
    #pragma unused cmdtext
    if (!IsPlayerAdmin(playerid)) SendClientMessage(playerid, COLOR_RED, "You're not an admin.");
	else {
        SetPlayerToTeamColor(playerid);
        PlayerOnDuty[playerid]=0;
	}
    return 1;
}
dcmd_a(playerid, cmdtext[]) {
    #pragma unused cmdtext
    new sendername[MAX_PLAYER_NAME];
    new string[256], idx;
    if (!IsPlayerAdmin(playerid)) SendClientMessage(playerid, COLOR_RED, "You're not an admin.");
    else {
        GetPlayerName(playerid, sendername, sizeof(sendername));
		new length = strlen(cmdtext);
		while ((idx < length) && (cmdtext[idx] <= ' '))
		{
			idx++;
		}
		new offset = idx;
		new result[64];
		while ((idx < length) && ((idx - offset) < (sizeof(result) - 1)))
		{
			result[idx - offset] = cmdtext[idx];
			idx++;
		}
		result[idx - offset] = EOS;
		if(!strlen(result))
		{
			SendClientMessage(playerid, COLOR_WHITE, "USAGE: /a <message>");
			return 1;
		}
		format(string, sizeof(string), "[AdminChat]%s: %s", sendername, result);
		SendAdminMessage(COLOR_ACHAT,string);
        return 1;
	}
    return 1;
}
dcmd_teamids(playerid, cmdtext[]) {
    #pragma unused cmdtext
    SendClientMessage(playerid, COLOR_RED, "These are the teamid's.");
    SendClientMessage(playerid, COLOR_WHITE, "Azteca: 0 | Vagos: 1 | Balla:  2 | O.G.F:  3 | Hoodlum: 4");
    SendClientMessage(playerid, COLOR_WHITE, "Rifa:   5 | Triad: 6 | DaNang: 7 | Worker: 8 | Cop: 9");
    SendClientMessage(playerid, COLOR_WHITE, "Guard: 10 | Biker:11 | Mafia: 12 | E.F.C: 13 | Mechanic: 14");
    return 1;
}
dcmd_teamstats(playerid, cmdtext[])
{
        #pragma unused cmdtext
        new giveteamid, idx, tmp[256];
		tmp = strtok(cmdtext, idx);

		if (!strlen(tmp))
		{
			for (new i = 0; i < MAX_TURFS; i++) {
                 new msg[ 256 ];
                 format(msg, sizeof(msg), "~w~%s stats:~n~~g~Turfwars Won: %d~n~~r~Turfwars Lost: %d~n~~w~Rivals killed: %d~n~Homies lost: %d~n~~y~Turfs: %d~n~~w~Teamscore: %d",
		         TeamInfo[ gTeam[playerid] ][ TeamName ], TeamInfo[ gTeam[playerid] ][ TurfWarsWon ],
				 TeamInfo[ gTeam[playerid] ][ TurfWarsLost ], TeamInfo[ gTeam[playerid] ][ RivalsKilled ],
				 TeamInfo[ gTeam[playerid] ][ HomiesDied ], OwnedTurfs(), TeamInfo[ gTeam[playerid] ][ TeamScore ]);
                 new Text:txt = TextDrawCreate( 33.0, 261.0, msg);
				 TextDrawUseBox( txt, 1 );
				 TextDrawBoxColor( txt, 0x00000066 );
				 TextDrawTextSize( txt, 141.0, 0.0 );
				 TextDrawAlignment( txt, 0 );
				 TextDrawBackgroundColor( txt, 0x000000ff );
				 TextDrawFont( txt, 1 );
				 TextDrawLetterSize( txt, 0.29, 1.0 );
				 TextDrawColor( txt, 0xffffffff );
				 TextDrawSetOutline( txt, 1 );
				 TextDrawSetProportional( txt, 1 );
				 TextDrawSetShadow( txt, 1 );
                 TimeTextForPlayer( playerid, txt, 6000 );
	             return 1;
	        }
		}
		giveteamid = strval(tmp);
		if ((giveteamid < 0 || giveteamid > 14)) {
            SendClientMessage(playerid, COLOR_RED, "No such teamid! Look at the teamid's.");
            SendClientMessage(playerid, COLOR_WHITE, "Azteca: 0 | Vagos: 1 | Balla:  2 | O.G.F:  3 | Hoodlum: 4");
            SendClientMessage(playerid, COLOR_WHITE, "Rifa:   5 | Triad: 6 | DaNang: 7 | Worker: 8 | Cop: 9");
            SendClientMessage(playerid, COLOR_WHITE, "Guard: 10 | Biker:11 | Mafia: 12 | E.F.C: 13 | Mechanic: 14");
            return 1;
		}
        for (new i = 0; i < MAX_TURFS; i++) {
             new msg[ 256 ];
             format(msg, sizeof(msg), "~w~%s stats:~n~~g~Turfwars Won: %d~n~~r~Turfwars Lost: %d~n~~w~Rivals killed: %d~n~Homies lost: %d~n~~y~Turfs: %d~n~~w~Teamscore: %d",
		     TeamInfo[ giveteamid ][ TeamName ], TeamInfo[ giveteamid ][ TurfWarsWon ],
			 TeamInfo[ giveteamid ][ TurfWarsLost ], TeamInfo[ giveteamid ][ RivalsKilled ],
			 TeamInfo[ giveteamid ][ HomiesDied ], OwnedTurfs2(giveteamid), TeamInfo[ giveteamid ][ TeamScore ]);
             new Text:txt = TextDrawCreate( 33.0, 261.0, msg);
			 TextDrawUseBox( txt, 1 );
			 TextDrawBoxColor( txt, 0x00000066 );
			 TextDrawTextSize( txt, 141.0, 0.0 );
			 TextDrawAlignment( txt, 0 );
			 TextDrawBackgroundColor( txt, 0x000000ff );
			 TextDrawFont( txt, 1 );
			 TextDrawLetterSize( txt, 0.29, 1.0 );
			 TextDrawColor( txt, 0xffffffff );
			 TextDrawSetOutline( txt, 1 );
			 TextDrawSetProportional( txt, 1 );
			 TextDrawSetShadow( txt, 1 );
             TimeTextForPlayer( playerid, txt, 6000 );
             return 1;
	    }
        return 1;
}
dcmd_sellpoints(playerid, cmdtext[]) {
     #pragma unused cmdtext
     new string[ 256 ], tmp[ 256 ];
     new sendername[ MAX_PLAYER_NAME ];
     new idx;

     tmp = strtok(cmdtext,idx);
     new setting = strval(tmp);
     if (!strlen(tmp)){
         SendClientMessage(playerid, COLOR_WHITE, "USAGE: /sellpoints [amount]");
         return 1;
     }
     else if (GetPlayerScore( playerid ) <= 0 ) {
         SendClientMessage( playerid, COLOR_RED, "You don't have enough points." );
         return 1;
     }
     else if (setting > 0) {
         GetPlayerName(playerid, sendername, sizeof(sendername));
         SetPlayerScore( playerid, GetPlayerScore(playerid)-setting );
         GivePlayerMoney( playerid, setting*250 );
         format(string,sizeof(string),"*** You've sold %d points.", setting);
         SendClientMessage( playerid, COLOR_GREEN, string );
         format(string,sizeof(string),"*** %s(%d) sold %d points.", sendername, playerid, setting);
         SendAdminMessage( COLOR_RED, string );
	 }
	 else SendClientMessage( playerid, COLOR_WHITE, "USAGE: /sellpoints [amount]" );
     return 1;
}
//==============================================================================

public OnPlayerEnterCheckpoint(playerid)
{
	switch(getCheckpointType(playerid))
	{
		case CP_AMMU: {
			SendClientMessage(playerid, COLOR_GREEN, "You can purchase weapons here so that you have them every");
			SendClientMessage(playerid, COLOR_GREEN, "time you spawn. You can purchase more than once for more ammo.");
			SendClientMessage(playerid, COLOR_YELLOW, "Type /buyweapon <weapon number> <weapon_amount> and /list or /list2 for a list of weapons.");
		}
		case CP_AMMU_2: {
			SendClientMessage(playerid, COLOR_GREEN, "You can purchase weapons here so that you have them every");
			SendClientMessage(playerid, COLOR_GREEN, "time you spawn. You can purchase more than once for more ammo.");
			SendClientMessage(playerid, COLOR_YELLOW, "Type /buyweapon <weapon number> <weapon_amount> and /list or /list2 for a list of weapons.");
		}
		case CP_AMMU_3: {
			SendClientMessage(playerid, COLOR_GREEN, "You can purchase weapons here so that you have them every");
			SendClientMessage(playerid, COLOR_GREEN, "time you spawn. You can purchase more than once for more ammo.");
			SendClientMessage(playerid, COLOR_YELLOW, "Type /buyweapon <weapon number> <weapon_amount> and /list or /list2 for a list of weapons.");
		}
		case CP_AMMU_4: {
			SendClientMessage(playerid, COLOR_GREEN, "You can purchase weapons here so that you have them every");
			SendClientMessage(playerid, COLOR_GREEN, "time you spawn. You can purchase more than once for more ammo.");
			SendClientMessage(playerid, COLOR_YELLOW, "Type /buyweapon <weapon number> <weapon_amount> and /list or /list2 for a list of weapons.");
		}
		case CP_AMMU_5: {
			SendClientMessage(playerid, COLOR_GREEN, "You can purchase weapons here so that you have them every");
			SendClientMessage(playerid, COLOR_GREEN, "time you spawn. You can purchase more than once for more ammo.");
			SendClientMessage(playerid, COLOR_YELLOW, "Type /buyweapon <weapon number> <weapon_amount> and /list or /list2 for a list of weapons.");
		}
		case CP_LSAP: {
            ShowMenuForPlayer( LSAMenu, playerid );
            TogglePlayerControllable( playerid, 0 );
		}
		case CP_LVAP: {
            ShowMenuForPlayer( LVAMenu, playerid );
            TogglePlayerControllable( playerid, 0 );
		}
		case CP_SFAP: {
            ShowMenuForPlayer( SFAMenu, playerid );
            TogglePlayerControllable( playerid, 0 );
		}
		case CP_LSTS: {
            ShowMenuForPlayer( LSTMenu, playerid );
            TogglePlayerControllable( playerid, 0 );
		}
		case CP_LVTS: {
            ShowMenuForPlayer( LVTMenu, playerid );
            TogglePlayerControllable( playerid, 0 );
		}
		case CP_SFTS: {
            ShowMenuForPlayer( SFTMenu, playerid );
            TogglePlayerControllable( playerid, 0 );
		}
    }
    return 1;
}
//==============================================================================

public OnPlayerPickUpPickup(playerid, pickupid)
{
 	if(gDropPickup[pickupid] != -1) {
 	    DestroyPickup(pickupid);
 	    KillTimer(gDropPickup[pickupid]);
 	    gDropPickup[pickupid] = -1;
	}
	return 1;
}
//==============================================================================

public PickupDestroy(pickupid)
{
	DestroyPickup(pickupid);
	gDropPickup[pickupid] = -1;
}
//==============================================================================

public TimeTextForPlayer( playerid, Text:text, time )
{
    TextDrawShowForPlayer( playerid, text );
    SetTimerEx( "DestroyTextTimer", time, 0, "i", _:text );
}

public DestroyTextTimer( Text:text )  TextDrawDestroy( text );
//==============================================================================

public OnPlayerText( playerid, text[] )
{
	if (!IsPlayerConnected( playerid )) return 0; // Check for undisconnected bug.
    new
        i,
        c;
    while ((c = text[i++])) if (c < 0x20 || c > 0x7E) return 0; // Check for illegal characters.
    
    return 1;
}
//==============================================================================

public OnPlayerPrivmsg( playerid, recieverid, text[] )
{
    if (!IsPlayerConnected( playerid )) return 0; // Check for undisconnected bug.
    new
        i,
        c;
    while ((c = text[i++])) if (c < 0x20 || c > 0x7E) return 0; // Check for illegal characters.

	new string[ 256 ], name[ 24 ], name2[ 24 ];
	GetPlayerName( recieverid, name, 24 );
	GetPlayerName( playerid, name2, 24 );
	format( string, sizeof(string),"*** [PM] %s(%d) to %s(%d): %s", name2, playerid, name, recieverid, text);
	for (new k = 0; k < SLOTS; k ++) {
		 if (IsPlayerConnected( k )) {
		     if (IsPlayerAdmin( k )) {
		         if (ShowPM[ k ] != 0) {
			         if (k != playerid && k != recieverid) SendClientMessage(k, COLOR_GREY, string);
		         }
	         }
	 	 }
	}
	return 1;
}
//==============================================================================

public OnPlayerTeamPrivmsg( playerid, msg[] )
{
   new string[256], name[24];
   GetPlayerName(playerid, name, 24);

   format(string, sizeof(string),"*** [TPM] %s(%d): %s", name, playerid, msg);
   for (new k = 0; k < SLOTS; k ++) {
		if (IsPlayerConnected(k)) {
		    if (IsPlayerAdmin( k )) {
		        if (ShowTPM[ k ] != 0) {
			        if (k != playerid && gTeam[playerid] != gTeam[k]) SendClientMessage(k, COLOR_TPM, string);
		        }
	        }
		}
   }
   return 1;
}
//==============================================================================

public SendAdminMessage( color, string[] )
{
	for (new i = 0; i < SLOTS; i++) {
		 if (IsPlayerConnected( i )) {
		     if (IsPlayerAdmin( i )) SendClientMessage( i, color, string );
		 }
	}
}
//==============================================================================

public GameModeInitExitFunc( )
{
	for (new i = 0; i < SLOTS; i++) if (IsPlayerConnected( i )) PlayerPlaySound( i, 1069, 0.0, 0.0, 0.0 );
	SetTimer( "GameModeExitFunc", 4000, 0 );
	return 1;
}
//==============================================================================

public GameModeExitFunc( ) {
    GameModeExit( );
    return 1;
}
//==============================================================================

stock AC_ResetPlayerMoney( playerid )
{
	lTMoney[ playerid ] = 0;
	lSMoney[ playerid ] = 0;

	ResetPlayerMoney( playerid );

	return 1;
}

stock AC_GivePlayerMoney( playerid, money )
{
	lTMoney[ playerid ]	+= money;
	lSMoney[ playerid ] =  0;

	GivePlayerMoney( playerid, money );

	return 1;
}

stock AC_GetPlayerMoney( playerid )return lTMoney[ playerid ];
//-------------------------------------

stock DropPlayerWeapons(playerid)
{
	new Float:x, Float:y, Float:z, Float:nx, Float:ny;
	new wep, val, pickupid, ammo, temp[10], bool:deny;

	GetPlayerPos(playerid,x,y,z);

	for(new i=0; i<13; i++)	{
	    deny = false;
		GetPlayerWeaponData(playerid, i, wep, ammo);
		for(new m=0; m<sizeof(gDenyWeaponDrop); m++) {
		    if(gDenyWeaponDrop[m] == wep) { deny = true; break; }
		}
	    if (!deny && wep != 0 && ammo > 0) {
	    	format(temp,sizeof(temp),"%.0f", x);
			val = strval(temp);
	        nx = RandomEx(val-2,val+2);
   	    	format(temp,sizeof(temp),"%.0f", y);
			val = strval(temp);
	        ny = RandomEx(val-2,val+2);
			pickupid = CreatePickup(GetWeaponPickupID(wep),3,nx,ny,z);
			gDropPickup[pickupid] = SetTimerEx("PickupDestroy",DROP_LENGTH,0,"i",pickupid);
		}
	}
	return 1;
}

stock GetWeaponPickupID(weaponid)
{
	new pickupid;
	switch(weaponid)
	{
	    case 1:  { pickupid = 331; }
	    case 2:  { pickupid = 333; }
	    case 3:  { pickupid = 334; }
	    case 4:  { pickupid = 335; }
	    case 5:  { pickupid = 336; }
	    case 6:  { pickupid = 337; }
	    case 7:  { pickupid = 338; }
	    case 8:  { pickupid = 339; }
	    case 9:  { pickupid = 341; }
	    case 10: { pickupid = 321; }
	    case 11: { pickupid = 322; }
	    case 12: { pickupid = 323; }
	    case 13: { pickupid = 324; }
	    case 14: { pickupid = 325; }
	    case 15: { pickupid = 326; }
	    case 16: { pickupid = 342; }
	    case 17: { pickupid = 343; }
	    case 18: { pickupid = 344; }
	    case 22: { pickupid = 346; }
		case 23: { pickupid = 347; }
		case 24: { pickupid = 348; }
		case 25: { pickupid = 349; }
		case 26: { pickupid = 350; }
		case 27: { pickupid = 351; }
		case 28: { pickupid = 352; }
		case 29: { pickupid = 353; }
		case 30: { pickupid = 355; }
		case 31: { pickupid = 356; }
		case 32: { pickupid = 372; }
		case 33: { pickupid = 357; }
		case 34: { pickupid = 358; }
		case 35: { pickupid = 359; }
		case 36: { pickupid = 360; }
		case 37: { pickupid = 361; }
		case 38: { pickupid = 362; }
		case 39: { pickupid = 363; }
		case 40: { pickupid = 364; }
		case 41: { pickupid = 365; }
		case 42: { pickupid = 366; }
		default: { pickupid = 0;   }
	}
	return pickupid;
}

stock RandomEx(min, max)
{
	new output;
	output = max-min;
	output = random(output);
	output = min+output;
	return output;
}
//-------------------------------------

stock OwnedTurfs( )
{
    new turf, playerid;
    for (new i = 0; i < MAX_TURFS; i++) if (turfs[ i ][TurfOwner] == gTeam[playerid]) turf++;
    return turf;
}
stock OwnedTurfs2( teamid )
{
    new turf;
    for (new i = 0; i < MAX_TURFS; i++) if (turfs[ i ][TurfOwner] == teamid) turf++;
    return turf;
}
//==============================================================================

strtok(const string[], &index)
{
	new length = strlen(string);
	while ((index < length) && (string[index] <= ' '))
	{
		index++;
	}

	new offset = index;
	new result[20];
	while ((index < length) && (string[index] > ' ') && ((index - offset) < (sizeof(result) - 1)))
	{
		result[index - offset] = string[index];
		index++;
	}
	result[index - offset] = EOS;
	return result;
}

//------------------------------------------------------------------------------
isStringSame(const string1[], const string2[], len) {
	for(new i = 0; i < len; i++) {
	    if(string1[i]!=string2[i])
	        return 0;
		if(string1[i] == 0 || string1[i] == '\n')
		    return 1;
	}
	return 1;
}

